/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.evidence.InstanceCommitHashModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class InstanceCommitHashModel_Builder {
    private String libraryInstanceRef;
    private List<String> commitHashes = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    InstanceCommitHashModel_Builder() {
    }

    public static InstanceCommitHashModel.Builder from(InstanceCommitHashModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new InstanceCommitHashModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="libraryInstanceRef")
    public InstanceCommitHashModel.Builder setLibraryInstanceRef(String libraryInstanceRef) {
        this.libraryInstanceRef = Objects.requireNonNull(libraryInstanceRef);
        this._unsetProperties.remove((Object)Property.LIBRARY_INSTANCE_REF);
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder mapLibraryInstanceRef(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setLibraryInstanceRef((String)mapper.apply(this.getLibraryInstanceRef()));
    }

    public String getLibraryInstanceRef() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) ? 1 : 0) != 0, (Object)"libraryInstanceRef not set");
        return this.libraryInstanceRef;
    }

    public InstanceCommitHashModel.Builder addCommitHashes(String element) {
        if (this.commitHashes instanceof ImmutableList) {
            this.commitHashes = new ArrayList<String>(this.commitHashes);
        }
        this.commitHashes.add(Objects.requireNonNull(element));
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder addCommitHashes(String ... elements) {
        return this.addAllCommitHashes(Arrays.asList(elements));
    }

    public InstanceCommitHashModel.Builder addAllCommitHashes(Spliterator<? extends String> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.commitHashes instanceof ImmutableList) {
                this.commitHashes = new ArrayList<String>(this.commitHashes);
            }
            ((ArrayList)this.commitHashes).ensureCapacity(this.commitHashes.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addCommitHashes);
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder addAllCommitHashes(BaseStream<? extends String, ?> elements) {
        return this.addAllCommitHashes(elements.spliterator());
    }

    @JsonProperty(value="commitHashes")
    public InstanceCommitHashModel.Builder addAllCommitHashes(Iterable<? extends String> elements) {
        return this.addAllCommitHashes(elements.spliterator());
    }

    public InstanceCommitHashModel.Builder mutateCommitHashes(Consumer<? super List<String>> mutator) {
        if (this.commitHashes instanceof ImmutableList) {
            this.commitHashes = new ArrayList<String>(this.commitHashes);
        }
        mutator.accept(this.commitHashes);
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder clearCommitHashes() {
        if (this.commitHashes instanceof ImmutableList) {
            this.commitHashes = ImmutableList.of();
        } else {
            this.commitHashes.clear();
        }
        return (InstanceCommitHashModel.Builder)this;
    }

    public List<String> getCommitHashes() {
        if (this.commitHashes instanceof ImmutableList) {
            this.commitHashes = new ArrayList<String>(this.commitHashes);
        }
        return Collections.unmodifiableList(this.commitHashes);
    }

    public InstanceCommitHashModel.Builder mergeFrom(InstanceCommitHashModel value) {
        InstanceCommitHashModel.Builder defaults = new InstanceCommitHashModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !Objects.equals(value.getLibraryInstanceRef(), ((InstanceCommitHashModel_Builder)defaults).getLibraryInstanceRef())) {
            this.setLibraryInstanceRef(value.getLibraryInstanceRef());
        }
        if (value instanceof Value && this.commitHashes == ImmutableList.of()) {
            this.commitHashes = ImmutableList.copyOf(value.getCommitHashes());
        } else {
            this.addAllCommitHashes(value.getCommitHashes());
        }
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder mergeFrom(InstanceCommitHashModel.Builder template) {
        InstanceCommitHashModel.Builder base = template;
        InstanceCommitHashModel.Builder defaults = new InstanceCommitHashModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) && Objects.equals(template.getLibraryInstanceRef(), ((InstanceCommitHashModel_Builder)defaults).getLibraryInstanceRef()))) {
            this.setLibraryInstanceRef(template.getLibraryInstanceRef());
        }
        this.addAllCommitHashes(base.commitHashes);
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel.Builder clear() {
        InstanceCommitHashModel.Builder defaults = new InstanceCommitHashModel.Builder();
        this.libraryInstanceRef = defaults.libraryInstanceRef;
        this.clearCommitHashes();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (InstanceCommitHashModel.Builder)this;
    }

    public InstanceCommitHashModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public InstanceCommitHashModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableList<String> commitHashes;
        private final EnumSet<Property> _unsetProperties;

        Partial(InstanceCommitHashModel_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.commitHashes = ImmutableList.copyOf((Collection)builder.commitHashes);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String getLibraryInstanceRef() {
            if (this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                throw new UnsupportedOperationException("libraryInstanceRef not set");
            }
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="commitHashes")
        public List<String> getCommitHashes() {
            return this.commitHashes;
        }

        @Override
        public InstanceCommitHashModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((InstanceCommitHashModel_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceCommitHashModel_Builder)builder).commitHashes = this.commitHashes;
            ((InstanceCommitHashModel_Builder)builder)._unsetProperties.clear();
            ((InstanceCommitHashModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.commitHashes, other.commitHashes) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.commitHashes, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial InstanceCommitHashModel{");
            if (!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                result.append("libraryInstanceRef=").append(this.libraryInstanceRef).append(", ");
            }
            return result.append("commitHashes=").append(this.commitHashes).append("}").toString();
        }

        private static class PartialBuilder
        extends InstanceCommitHashModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public InstanceCommitHashModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableList<String> commitHashes;

        private Value(InstanceCommitHashModel_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.commitHashes = ImmutableList.copyOf((Collection)builder.commitHashes);
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String getLibraryInstanceRef() {
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="commitHashes")
        public List<String> getCommitHashes() {
            return this.commitHashes;
        }

        @Override
        public InstanceCommitHashModel.Builder toBuilder() {
            InstanceCommitHashModel.Builder builder = new InstanceCommitHashModel.Builder();
            ((InstanceCommitHashModel_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceCommitHashModel_Builder)builder).commitHashes = this.commitHashes;
            ((InstanceCommitHashModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.commitHashes, other.commitHashes);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.commitHashes);
        }

        public String toString() {
            return "InstanceCommitHashModel{libraryInstanceRef=" + this.libraryInstanceRef + ", commitHashes=" + this.commitHashes + "}";
        }
    }

    private static abstract class Rebuildable
    implements InstanceCommitHashModel {
        private Rebuildable() {
        }

        public abstract InstanceCommitHashModel.Builder toBuilder();
    }

    private static enum Property {
        LIBRARY_INSTANCE_REF("libraryInstanceRef");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

