/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.IssueModel;
import com.sourceclear.api.data.issues.IssueType;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class IssueModel_Vuln_Builder {
    private IssueType type;
    private long id;
    private IssueModel.IssueStatus status;
    private URI issueUrl = null;
    private Object vuln;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    IssueModel_Vuln_Builder() {
    }

    public static IssueModel.Vuln.Builder from(IssueModel.Vuln value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new IssueModel.Vuln.Builder().mergeFrom(value);
    }

    @JsonProperty(value="type")
    public IssueModel.Vuln.Builder setType(IssueType type) {
        this.type = Objects.requireNonNull(type);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapType(UnaryOperator<IssueType> mapper) {
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public IssueModel.Vuln.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="status")
    public IssueModel.Vuln.Builder setStatus(IssueModel.IssueStatus status) {
        this.status = Objects.requireNonNull(status);
        this._unsetProperties.remove((Object)Property.STATUS);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapStatus(UnaryOperator<IssueModel.IssueStatus> mapper) {
        Objects.requireNonNull(mapper);
        return this.setStatus((IssueModel.IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueModel.IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    public IssueModel.Vuln.Builder setIssueUrl(URI issueUrl) {
        this.issueUrl = Objects.requireNonNull(issueUrl);
        return (IssueModel.Vuln.Builder)this;
    }

    @JsonProperty(value="issueUrl")
    public IssueModel.Vuln.Builder setIssueUrl(Optional<? extends URI> issueUrl) {
        if (issueUrl.isPresent()) {
            return this.setIssueUrl(issueUrl.get());
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Vuln.Builder setNullableIssueUrl(@Nullable URI issueUrl) {
        if (issueUrl != null) {
            return this.setIssueUrl(issueUrl);
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Vuln.Builder mapIssueUrl(UnaryOperator<URI> mapper) {
        return this.setIssueUrl(this.getIssueUrl().map(mapper));
    }

    public IssueModel.Vuln.Builder clearIssueUrl() {
        this.issueUrl = null;
        return (IssueModel.Vuln.Builder)this;
    }

    public Optional<URI> getIssueUrl() {
        return Optional.ofNullable(this.issueUrl);
    }

    @JsonProperty(value="vuln")
    public IssueModel.Vuln.Builder setVuln(Object vuln) {
        this.vuln = Objects.requireNonNull(vuln);
        this._unsetProperties.remove((Object)Property.VULN);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapVuln(UnaryOperator<Object> mapper) {
        Objects.requireNonNull(mapper);
        return this.setVuln(mapper.apply(this.getVuln()));
    }

    public Object getVuln() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VULN) ? 1 : 0) != 0, (Object)"vuln not set");
        return this.vuln;
    }

    public IssueModel.Vuln.Builder mergeFrom(IssueModel.Vuln value) {
        IssueModel.Vuln.Builder defaults = new IssueModel.Vuln.Builder();
        if (!Objects.equals((Object)value.getType(), (Object)((IssueModel_Vuln_Builder)defaults).getType())) {
            this.setType(value.getType());
        }
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((IssueModel_Vuln_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        if (defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((IssueModel_Vuln_Builder)defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        value.getIssueUrl().ifPresent(this::setIssueUrl);
        if (defaults._unsetProperties.contains((Object)Property.VULN) || !Objects.equals(value.getVuln(), ((IssueModel_Vuln_Builder)defaults).getVuln())) {
            this.setVuln(value.getVuln());
        }
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mergeFrom(IssueModel.Vuln.Builder template) {
        IssueModel.Vuln.Builder defaults = new IssueModel.Vuln.Builder();
        if (!Objects.equals((Object)template.getType(), (Object)((IssueModel_Vuln_Builder)defaults).getType())) {
            this.setType(template.getType());
        }
        IssueModel.Vuln.Builder base = template;
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((IssueModel_Vuln_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((IssueModel_Vuln_Builder)defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        template.getIssueUrl().ifPresent(this::setIssueUrl);
        if (!(base._unsetProperties.contains((Object)Property.VULN) || !defaults._unsetProperties.contains((Object)Property.VULN) && Objects.equals(template.getVuln(), ((IssueModel_Vuln_Builder)defaults).getVuln()))) {
            this.setVuln(template.getVuln());
        }
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder clear() {
        IssueModel.Vuln.Builder defaults = new IssueModel.Vuln.Builder();
        this.type = defaults.type;
        this.id = defaults.id;
        this.status = defaults.status;
        this.issueUrl = defaults.issueUrl;
        this.vuln = defaults.vuln;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public IssueModel.Vuln buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;
        private final Object vuln;
        private final EnumSet<Property> _unsetProperties;

        Partial(IssueModel_Vuln_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
            this.vuln = builder.vuln;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        @JsonProperty(value="vuln")
        public Object getVuln() {
            if (this._unsetProperties.contains((Object)Property.VULN)) {
                throw new UnsupportedOperationException("vuln not set");
            }
            return this.vuln;
        }

        @Override
        public IssueModel.Vuln.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((IssueModel_Vuln_Builder)builder).type = this.type;
            ((IssueModel_Vuln_Builder)builder).id = this.id;
            ((IssueModel_Vuln_Builder)builder).status = this.status;
            ((IssueModel_Vuln_Builder)builder).issueUrl = this.issueUrl;
            ((IssueModel_Vuln_Builder)builder).vuln = this.vuln;
            ((IssueModel_Vuln_Builder)builder)._unsetProperties.clear();
            ((IssueModel_Vuln_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && this.id == other.id && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl) && Objects.equals(this.vuln, other.vuln) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl, this.vuln, this._unsetProperties});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial Vuln{type=").append((Object)this.type);
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append(", id=").append(this.id);
            }
            if (!this._unsetProperties.contains((Object)Property.STATUS)) {
                result.append(", status=").append((Object)this.status);
            }
            if (this.issueUrl != null) {
                result.append(", issueUrl=").append(this.issueUrl);
            }
            if (!this._unsetProperties.contains((Object)Property.VULN)) {
                result.append(", vuln=").append(this.vuln);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends IssueModel.Vuln.Builder {
            private PartialBuilder() {
            }

            @Override
            public IssueModel.Vuln build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;
        private final Object vuln;

        private Value(IssueModel_Vuln_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
            this.vuln = builder.vuln;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        @JsonProperty(value="vuln")
        public Object getVuln() {
            return this.vuln;
        }

        @Override
        public IssueModel.Vuln.Builder toBuilder() {
            IssueModel.Vuln.Builder builder = new IssueModel.Vuln.Builder();
            ((IssueModel_Vuln_Builder)builder).type = this.type;
            ((IssueModel_Vuln_Builder)builder).id = this.id;
            ((IssueModel_Vuln_Builder)builder).status = this.status;
            ((IssueModel_Vuln_Builder)builder).issueUrl = this.issueUrl;
            ((IssueModel_Vuln_Builder)builder).vuln = this.vuln;
            ((IssueModel_Vuln_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && this.id == other.id && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl) && Objects.equals(this.vuln, other.vuln);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl, this.vuln});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("Vuln{type=").append((Object)this.type).append(", id=").append(this.id).append(", status=").append((Object)this.status);
            if (this.issueUrl != null) {
                result.append(", issueUrl=").append(this.issueUrl);
            }
            return result.append(", vuln=").append(this.vuln).append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements IssueModel.Vuln {
        private Rebuildable() {
        }

        public abstract IssueModel.Vuln.Builder toBuilder();
    }

    private static enum Property {
        ID("id"),
        STATUS("status"),
        VULN("vuln");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

