/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.sourceclear.api.data.events.Event;
import com.sourceclear.api.data.events.OrgModel;
import com.sourceclear.api.data.events.RepoModel;
import com.sourceclear.api.data.events.ScanSuccessEvent;
import com.sourceclear.api.data.events.UserModel;
import com.sourceclear.api.data.events.VulnIssueEvent;
import com.sourceclear.api.data.events.WorkspaceModel;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, visible=true, property="event", defaultImpl=EventMessage.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ScanSuccessEvent.class, name="SCAN_SUCCESS"), @JsonSubTypes.Type(value=VulnIssueEvent.class, name="VULN_ISSUES_DISCOVERED_AFTER_SCAN"), @JsonSubTypes.Type(value=VulnIssueEvent.class, name="VULN_ISSUES_CHANGED_AFTER_SCAN")})
public class EventMessage {
    @JsonProperty
    @JsonTypeId
    Event event;
    @JsonProperty(value="project")
    RepoModel repo;
    @JsonProperty
    OrgModel organization;
    @JsonProperty
    WorkspaceModel workspace;
    @JsonProperty
    UserModel user;

    public static EventMessage repoEvent(Event event, RepoModel repo, WorkspaceModel workspace, OrgModel org, UserModel user) {
        return new EventMessage(event, repo, workspace, org, user);
    }

    public static EventMessage workspaceEvent(Event event, WorkspaceModel workspace, OrgModel org, UserModel user) {
        return new EventMessage(event, null, workspace, org, user);
    }

    public static EventMessage orgEvent(Event event, OrgModel org, UserModel user) {
        return new EventMessage(event, null, null, org, user);
    }

    public EventMessage(Event event, RepoModel repo, WorkspaceModel workspace, OrgModel organization, UserModel user) {
        this.event = event;
        this.repo = repo;
        this.organization = organization;
        this.workspace = workspace;
        this.user = user;
    }

    public EventMessage() {
    }

    public String toString() {
        return "EventMessage{event='" + (Object)((Object)this.event) + '\'' + ", repo='" + this.repo + '\'' + ", organization='" + this.organization + '\'' + ", workspace='" + this.workspace + '\'' + ", user='" + this.user + '\'' + '}';
    }

    public Event getEvent() {
        return this.event;
    }

    public Optional<RepoModel> getRepo() {
        return Optional.ofNullable(this.repo);
    }

    public OrgModel getOrganization() {
        return this.organization;
    }

    public Optional<WorkspaceModel> getWorkspace() {
        return Optional.ofNullable(this.workspace);
    }

    public Optional<UserModel> getUser() {
        return Optional.ofNullable(this.user);
    }

    public void setUser(UserModel user) {
        this.user = user;
    }
}

