/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class OrgIdentifier {
    private static final String DELIMITER = "-";
    private final Type type;
    private final long id;

    public static OrgIdentifier of(Type type, long id) {
        return new OrgIdentifier(type, id);
    }

    private OrgIdentifier(Type type, long id) {
        this.type = type;
        this.id = id;
    }

    public Type getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.type.toString().toLowerCase() + DELIMITER + this.id;
    }

    @JsonCreator
    public static OrgIdentifier valueOf(String identifier) {
        String[] parts = identifier.split(DELIMITER, 2);
        if (parts.length == 2) {
            Type type = (Type)EnumUtils.getEnum(Type.class, (String)parts[0].toUpperCase());
            long id = NumberUtils.toLong((String)parts[1], (long)-1L);
            if (type != null && id != -1L) {
                return new OrgIdentifier(type, id);
            }
        }
        throw new IllegalStateException("Unable to parse identifier into component parts: " + identifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgIdentifier that = (OrgIdentifier)o;
        return this.id == that.id && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id});
    }

    public static enum Type {
        SOURCECLEAR,
        VERACODE;

    }
}

