/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.security.logging;

import com.veracode.security.logging.SecureExceptionWrapper;
import com.veracode.security.logging.SecureLoggerUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class SecureLogger
implements Logger {
    private final Logger baseLogger;

    public static SecureLogger getLogger(String name) {
        return new SecureLogger(name);
    }

    public static SecureLogger getLogger(Class clazz) {
        return new SecureLogger(clazz);
    }

    protected SecureLogger(String name) {
        this.baseLogger = LoggerFactory.getLogger((String)name);
    }

    protected SecureLogger(Class clazz) {
        this.baseLogger = LoggerFactory.getLogger((Class)clazz);
    }

    public Logger getBaseLogger() {
        return this.baseLogger;
    }

    public String getName() {
        return this.baseLogger.getName();
    }

    public boolean isTraceEnabled() {
        return this.baseLogger.isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.baseLogger.isTraceEnabled(marker);
    }

    public void trace(String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.trace(escapedString);
    }

    public void trace(String format, Object arg) {
        Object escapedString = SecureLoggerUtil.escapeMessage(arg);
        this.baseLogger.trace(format, escapedString);
    }

    public void trace(String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.trace(format, str1, str2);
    }

    public void trace(String format, Object ... arguments) {
        this.baseLogger.trace(format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void trace(String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.trace(escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public void trace(Marker marker, String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.trace(marker, escapedString);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.baseLogger.trace(marker, format, SecureLoggerUtil.escapeMessages(arg));
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.trace(marker, format, str1, str2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.baseLogger.trace(marker, format, SecureLoggerUtil.escapeMessages(argArray));
    }

    public void trace(Marker marker, String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.trace(marker, escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public boolean isDebugEnabled() {
        return this.baseLogger.isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.baseLogger.isDebugEnabled(marker);
    }

    public void debug(String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.debug(escapedString);
    }

    public void debug(String format, Object arg) {
        this.baseLogger.debug(format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.debug(format, str1, str2);
    }

    public void debug(String format, Object ... arguments) {
        this.baseLogger.debug(format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void debug(String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.debug(escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public void debug(Marker marker, String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.debug(marker, escapedString);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.baseLogger.debug(marker, format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.debug(marker, format, str1, str2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.baseLogger.debug(marker, format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void debug(Marker marker, String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.debug(marker, escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public boolean isInfoEnabled() {
        return this.baseLogger.isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.baseLogger.isInfoEnabled(marker);
    }

    public void info(String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.info(escapedString);
    }

    public void info(String format, Object arg) {
        this.baseLogger.info(format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.info(format, str1, str2);
    }

    public void info(String format, Object ... arguments) {
        this.baseLogger.info(format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void info(String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.info(escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public void info(Marker marker, String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.info(marker, escapedString);
    }

    public void info(Marker marker, String format, Object arg) {
        this.baseLogger.info(marker, format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.info(marker, format, str1, str2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.baseLogger.info(marker, format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void info(Marker marker, String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.info(marker, escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public boolean isWarnEnabled() {
        return this.baseLogger.isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.baseLogger.isWarnEnabled(marker);
    }

    public void warn(String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.warn(escapedString);
    }

    public void warn(String format, Object arg) {
        this.baseLogger.warn(format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void warn(String format, Object ... arguments) {
        this.baseLogger.warn(format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.warn(format, str1, str2);
    }

    public void warn(String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.warn(escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public void warn(Marker marker, String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.warn(marker, escapedString);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.baseLogger.warn(marker, format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.warn(marker, format, str1, str2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.baseLogger.warn(marker, format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void warn(Marker marker, String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.warn(marker, escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public boolean isErrorEnabled() {
        return this.baseLogger.isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.baseLogger.isErrorEnabled(marker);
    }

    public void error(String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.error(escapedString);
    }

    public void error(String format, Object arg) {
        this.baseLogger.error(format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.error(format, str1, str2);
    }

    public void error(String format, Object ... arguments) {
        this.baseLogger.error(format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void error(String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.error(escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public void error(Marker marker, String msg) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.error(marker, escapedString);
    }

    public void error(Marker marker, String format, Object arg) {
        this.baseLogger.error(marker, format, SecureLoggerUtil.escapeMessage(arg));
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        Object str1 = SecureLoggerUtil.escapeMessage(arg1);
        Object str2 = SecureLoggerUtil.escapeMessage(arg2);
        this.baseLogger.error(marker, format, str1, str2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.baseLogger.error(marker, format, SecureLoggerUtil.escapeMessages(arguments));
    }

    public void error(Marker marker, String msg, Throwable t) {
        String escapedString = SecureLoggerUtil.escapeMessage(msg);
        this.baseLogger.error(marker, escapedString, (Throwable)new SecureExceptionWrapper(t));
    }

    public static void addContext(Map<String, String> context) {
        if (context != null) {
            for (Map.Entry<String, String> entry : context.entrySet()) {
                SecureLogger.addContext(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void addContextIfEmpty(String key, String value) {
        if (key != null && MDC.get((String)SecureLoggerUtil.escapeMessage(key)) == null) {
            SecureLogger.addContext(key, value);
        }
    }

    public static void addContext(String key, String value) {
        if (key != null) {
            MDC.put((String)SecureLoggerUtil.escapeMessage(key), (String)SecureLoggerUtil.escapeMessage(value));
        }
    }

    public static void removeContext(Map<String, String> context) {
        if (context != null) {
            for (String key : context.keySet()) {
                SecureLogger.removeContext(key);
            }
        }
    }

    public static void removeContext(String key) {
        if (key != null) {
            MDC.remove((String)SecureLoggerUtil.escapeMessage(key));
        }
    }

    public static void clearContext() {
        MDC.clear();
    }
}

