/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io.renderers;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;

public class AgentOutputFormatter {
    private static final char ESC = '\u001b';
    private static final String RESET = "\u001b[0m";
    private static final String RED = "\u001b[31;1m";
    private static final String BLUE = "\u001b[34;1m";
    private static final int MAX_PAD_COUNT = 100;
    private Boolean withColor = null != System.console() || Boolean.getBoolean("force.ansi");

    public String red(String text) {
        if (this.withColor.booleanValue()) {
            return String.format("%s%s%s", RED, text, RESET);
        }
        return text;
    }

    public String blue(String text) {
        if (this.withColor.booleanValue()) {
            return String.format("%s%s%s", BLUE, text, RESET);
        }
        return text;
    }

    public int calculateLongestLine(String text) {
        String[] lines;
        int longestLine = 0;
        for (String line : lines = text.split("\\r?\\n")) {
            longestLine = Math.max(longestLine, line.length());
        }
        longestLine = Math.min(100, longestLine);
        return longestLine;
    }

    public String createLineHeadersWithChar(@Nonnull char padChar, int count) {
        return Strings.padEnd((String)"", (int)count, (char)padChar);
    }
}

