/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.expr;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.step.ImmutableNamed;
import com.sourceclear.sgl.lang.step.Named;
import com.sourceclear.sgl.lang.step.Step;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Patterns
implements Expr {
    private final List<Named> steps;

    public Patterns(List<Named> steps) {
        if (steps.size() < 2) {
            throw new IllegalStateException("a pattern must consist of one or more named steps");
        }
        this.steps = steps;
    }

    public static Patterns of(Step step, String start, String end) {
        return new Patterns(Collections.singletonList(Named.create(step, start, end)));
    }

    @Override
    public <E, T, A> E accept(ASTVisitor<E, T, A> visitor2) {
        return visitor2.visitPatterns(this);
    }

    @Override
    public boolean isSGDL() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Patterns patterns = (Patterns)o;
        return Objects.equals(this.steps, patterns.steps);
    }

    public int hashCode() {
        return Objects.hash(this.steps);
    }

    public String toString() {
        return "Patterns{steps=" + this.steps + '}';
    }

    public boolean isSingleton() {
        return this.steps.size() == 1;
    }

    public List<Named> getNamed() {
        return this.steps;
    }

    public Patterns mapSteps(Function<Step, Step> f) {
        return new Patterns(this.steps.stream().map(s -> ImmutableNamed.builder().from((Named)s).step((Step)f.apply(s.step())).build()).collect(Collectors.toList()));
    }

    public List<Step> getSteps() {
        return this.steps.stream().map(Named::step).collect(Collectors.toList());
    }
}

