/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.argument;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Predicate;
import com.sourceclear.sgl.lang.step.Step;
import com.sourceclear.sgl.lang.value.Value;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public abstract class Argument {
    @Nullable
    private final String keyword;

    public Argument(String keyword) {
        this.keyword = keyword;
    }

    public abstract <E, T, A> A accept(ASTVisitor<E, T, A> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument argument = (Argument)o;
        return Objects.equals(this.keyword, argument.keyword);
    }

    public int hashCode() {
        return Objects.hash(this.keyword);
    }

    public static Argument of(Predicate predicate) {
        return new PredicateArgument(predicate);
    }

    public static Argument of(Step step) {
        return new StepArgument(null, step);
    }

    public static Argument of(String keyword, Step step) {
        return new StepArgument(keyword, step);
    }

    public static Argument of(Value value) {
        return new PredicateArgument(new Eq(value));
    }

    public static Argument of(String keyword, Predicate predicate) {
        return new PredicateArgument(keyword, predicate);
    }

    public static Argument of(String keyword, Value value) {
        return new PredicateArgument(keyword, new Eq(value));
    }

    public Optional<String> getKeyword() {
        return Optional.ofNullable(this.keyword);
    }

    public boolean isValue() {
        return this instanceof PredicateArgument;
    }

    public boolean isStep() {
        return this instanceof StepArgument;
    }

    public Value asValue() {
        if (!(this instanceof PredicateArgument)) {
            throw new RuntimeException("attempt to get value from non-predicate");
        }
        return ((PredicateArgument)this).getValueUnsafe();
    }

    public StepArgument asStep() {
        if (!(this instanceof StepArgument)) {
            throw new RuntimeException("not a step");
        }
        return (StepArgument)this;
    }
}

