/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.Action;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.step.Step;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BindingExpansionVisitor
extends ASTVisitor<Expr, Step, Argument> {
    private final Map<String, Step> env = new HashMap<String, Step>();
    private final Set<String> seen = new HashSet<String>();

    public static Expr expand(Expr expr) {
        return expr.accept(new BindingExpansionVisitor());
    }

    @Override
    public Expr visitBindingSequence(BindingSequence bindingSequence) {
        bindingSequence.getBindings().forEach(b -> this.env.put(b.getVariable(), b.getExpr()));
        return bindingSequence.getBody().accept(this);
    }

    @Override
    public Expr visitSequence(Sequence sequence) {
        List<Action> result = sequence.getActions().stream().map(a -> (Action)a.accept(this)).collect(Collectors.toList());
        return new Sequence(result);
    }

    @Override
    public Expr visitAddAction(AddAction action) {
        return new AddAction(action.getStep().accept(this));
    }

    @Override
    public Expr visitRemoveAction(RemoveAction action) {
        return new RemoveAction(action.getStep().accept(this));
    }

    @Override
    public Expr visitQuery(Query query) {
        return new Query(query.getStep().accept(this));
    }

    @Override
    public Step visitStep(Step step) {
        if (this.isBinding(step)) {
            Step resolved = step.getNext().map(n -> this.env.get(step.getName()).concat((Step)n)).orElseGet(() -> this.env.get(step.getName()));
            String name = resolved.getName();
            if (this.seen.contains(name)) {
                throw new RuntimeException("cyclic binding of " + this.seen);
            }
            this.seen.add(name);
            return this.visitStep(resolved);
        }
        this.seen.clear();
        List<Argument> args = step.getArguments().stream().map(a -> a.accept(this)).collect(Collectors.toList());
        Step next = step.getNext().map(this::visitStep).orElse(null);
        return new Step(step.getName(), args, next);
    }

    @Override
    public Argument visitPredicateArgument(PredicateArgument predicateArgument) {
        return predicateArgument;
    }

    @Override
    public Argument visitTraversalArgument(StepArgument stepArgument) {
        return new StepArgument(stepArgument.getKeyword().orElse(null), stepArgument.getStep().accept(this));
    }

    @Override
    public Argument visitWildcardArgument(WildcardArgument wildcardArgument) {
        return wildcardArgument;
    }

    @Override
    public Patterns visitPatterns(Patterns patterns) {
        return patterns.mapSteps(s -> s.accept(this));
    }

    private boolean isBinding(Step step) {
        return this.env.containsKey(step.getName()) && step.getArguments().isEmpty();
    }
}

