/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.sgl.SglDate;
import com.sourceclear.sgl.Utility;
import com.sourceclear.sgl.Vertex;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;

public class VulnerabilitySource
implements Vertex {
    @JsonProperty
    private final String type = "vulnerability_source";
    @JsonProperty
    private final String sourceType;
    @JsonProperty
    private final int identity;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final Date released;

    public VulnerabilitySource(String sourceType, int identity, String description, Instant released) {
        this(sourceType, identity, description, new Date(released.toEpochMilli()));
    }

    @JsonCreator
    public VulnerabilitySource(@JsonProperty(value="sourceType") String sourceType, @JsonProperty(value="identity") int identity, @JsonProperty(value="description") String description, @JsonProperty(value="released") Date released) {
        this.sourceType = sourceType;
        this.identity = identity;
        this.description = description;
        this.released = released;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VulnerabilitySource that = (VulnerabilitySource)o;
        return this.identity == that.identity && Objects.equals("vulnerability_source", that.type) && Objects.equals(this.sourceType, that.sourceType) && Objects.equals(this.description, that.description) && Objects.equals(this.released, that.released);
    }

    public int hashCode() {
        return Objects.hash("vulnerability_source", this.sourceType, this.identity, this.description, this.released);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("vulnerability_source(");
        sb.append("type:").append(this.sourceType).append(", ");
        sb.append("identity:").append(this.identity).append(", ");
        sb.append("description:").append(Utility.quoteString(this.description)).append(", ");
        sb.append("released:").append(SglDate.printSglDate(this.released));
        sb.append(')');
        return sb.toString();
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public int getIdentity() {
        return this.identity;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getReleased() {
        return this.released;
    }
}

