/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.sgl.EdgeResult;
import com.sourceclear.sgl.File;
import com.sourceclear.sgl.Hash;
import com.sourceclear.sgl.Library;
import com.sourceclear.sgl.LibraryHash;
import com.sourceclear.sgl.License;
import com.sourceclear.sgl.Method;
import com.sourceclear.sgl.MethodHash;
import com.sourceclear.sgl.Numeric;
import com.sourceclear.sgl.Result;
import com.sourceclear.sgl.SGL;
import com.sourceclear.sgl.SglClass;
import com.sourceclear.sgl.SglList;
import com.sourceclear.sgl.SglPath;
import com.sourceclear.sgl.SglString;
import com.sourceclear.sgl.Variable;
import com.sourceclear.sgl.VersionRange;
import com.sourceclear.sgl.Vertex;
import com.sourceclear.sgl.Vulnerability;
import com.sourceclear.sgl.VulnerabilitySource;
import com.sourceclear.sgl.dsl.SGLSchema;
import com.sourceclear.sgl.lang.ImmutableCompileConfig;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.javatuples.Pair;

public final class TinkerPop
extends SGLSchema.TinkerPop {
    public static final String STARTING_VERTICES_START = "starting_vertices_start";
    public static final String STARTING_VERTICES_END = "starting_vertices_end";
    private static final ImmutableMap<String, Function<org.apache.tinkerpop.gremlin.structure.Vertex, Vertex>> vertexTransformers = ImmutableMap.builder().put((Object)"library", v -> {
        String language = TinkerPop.getPropertyOrKey(v, "language", String.class);
        String coord1 = TinkerPop.getPropertyOrKey(v, "coord1", String.class);
        String coord2 = TinkerPop.getPropertyOrKey(v, "coord2", String.class);
        String version = TinkerPop.getPropertyOrKey(v, "version", String.class);
        return new Library(language, coord1, coord2, version);
    }).put((Object)"library_hash", v -> {
        String name = TinkerPop.getKey(v, "_hash", String.class);
        return new LibraryHash(name);
    }).put((Object)"method", v -> {
        String language = TinkerPop.getKey(v, "_language", String.class);
        String coord1 = TinkerPop.getKey(v, "_coord1", String.class);
        String coord2 = TinkerPop.getKey(v, "_coord2", String.class);
        String version = TinkerPop.getKey(v, "_version", String.class);
        String moduleName = TinkerPop.getPropertyOrKey(v, "module_name", String.class);
        String className = TinkerPop.getPropertyOrKey(v, "class_name", String.class);
        String methodName = TinkerPop.getPropertyOrKey(v, "method_name", String.class);
        String descriptor = TinkerPop.getKey(v, "_descriptor", String.class);
        return new Method(language, coord1, coord2, version, moduleName, className, methodName, descriptor);
    }).put((Object)"class", v -> {
        String language = TinkerPop.getPropertyOrKey(v, "language", String.class);
        String coord1 = TinkerPop.getPropertyOrKey(v, "coord1", String.class);
        String coord2 = TinkerPop.getPropertyOrKey(v, "coord2", String.class);
        String version = TinkerPop.getPropertyOrKey(v, "version", String.class);
        String name = TinkerPop.getPropertyOrKey(v, "name", String.class);
        return new SglClass(language, coord1, coord2, version, name);
    }).put((Object)"vulnerability", v -> {
        int cwe = TinkerPop.getPropertyOrKey(v, "cwe", Integer.class);
        String query = TinkerPop.getPropertyOrKey(v, "query", String.class);
        return new Vulnerability(cwe, query);
    }).put((Object)"file", v -> {
        String language = TinkerPop.getKey(v, "_language", String.class);
        String coord1 = TinkerPop.getKey(v, "_coord1", String.class);
        String coord2 = TinkerPop.getKey(v, "_coord2", String.class);
        String version = TinkerPop.getKey(v, "_version", String.class);
        String name = TinkerPop.getKey(v, "_name", String.class);
        return new File(language, coord1, coord2, version, name);
    }).put((Object)"method_hash", v -> {
        int length = TinkerPop.getKey(v, "_length", Integer.class);
        String hash = TinkerPop.getPropertyOrKey(v, "hash", String.class);
        return new MethodHash(length, hash);
    }).put((Object)"version_range", v -> {
        String language = TinkerPop.getKey(v, "_language", String.class);
        String coord1 = TinkerPop.getKey(v, "_coord1", String.class);
        String coord2 = TinkerPop.getKey(v, "_coord2", String.class);
        String from = TinkerPop.getKey(v, "_from", String.class);
        String to = TinkerPop.getKey(v, "_to", String.class);
        return new VersionRange(language, coord1, coord2, from, to);
    }).put((Object)"license", v -> {
        String name = TinkerPop.getPropertyOrKey(v, "name", String.class);
        return new License(name);
    }).put((Object)"vulnerability_source", v -> {
        String type = TinkerPop.getPropertyOrKey(v, "type", String.class);
        int identity = TinkerPop.getPropertyOrKey(v, "identity", Integer.class);
        String desc = TinkerPop.getPropertyOrKey(v, "description", String.class);
        Date released = TinkerPop.getPropertyOrKey(v, "released", Date.class);
        return new VulnerabilitySource(type, identity, desc, released);
    }).put((Object)"variable", v -> {
        String language = TinkerPop.getPropertyOrKey(v, "language", String.class);
        String coord1 = TinkerPop.getPropertyOrKey(v, "coord1", String.class);
        String coord2 = TinkerPop.getPropertyOrKey(v, "coord2", String.class);
        String version = TinkerPop.getPropertyOrKey(v, "version", String.class);
        String name = TinkerPop.getPropertyOrKey(v, "name", String.class);
        String moduleName = TinkerPop.getPropertyOrKey(v, "module_name", String.class);
        String className = TinkerPop.getPropertyOrKey(v, "class_name", String.class);
        String methodName = TinkerPop.getPropertyOrKey(v, "method_name", String.class);
        String descriptor = TinkerPop.getKey(v, "_descriptor", String.class);
        return new Variable(language, coord1, coord2, version, moduleName, className, methodName, descriptor, name);
    }).build();
    private static final ImmutableMap<String, Function<Edge, Map<String, Object>>> edgeTransformers = ImmutableMap.builder().put((Object)"calls", v -> {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("at", v.property("at").value());
        return result;
    }).build();

    public static List<Result> toResults(List<?> node) {
        return node.stream().map(TinkerPop::toResult).collect(Collectors.toList());
    }

    public static Result toResult(Object object) {
        if (object instanceof org.apache.tinkerpop.gremlin.structure.Vertex) {
            org.apache.tinkerpop.gremlin.structure.Vertex vertex = (org.apache.tinkerpop.gremlin.structure.Vertex)object;
            String label = vertex.label();
            if (label.isEmpty()) {
                label = TinkerPop.getKey(vertex, "~label", String.class);
            }
            return (Result)((Function)vertexTransformers.get((Object)label)).apply(vertex);
        }
        if (object instanceof Edge) {
            Edge edge = (Edge)object;
            String label = edge.label();
            Map properties = Optional.ofNullable((Function)edgeTransformers.get((Object)label)).map(l -> (Map)l.apply(edge)).orElseGet(HashMap::new);
            Result from = TinkerPop.toResult(edge.outVertex());
            Result to = TinkerPop.toResult(edge.inVertex());
            return new EdgeResult(label, from, to, properties);
        }
        if (object instanceof Integer) {
            return new Numeric(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new Numeric((Long)object);
        }
        if (object instanceof String) {
            return new SglString((String)object);
        }
        if (object instanceof Path) {
            Path path = (Path)object;
            return new SglPath(path.stream().map(Pair::getValue0).map(TinkerPop::toResult).collect(Collectors.toList()));
        }
        if (object instanceof List) {
            List properties = (List)object;
            return new SglList(properties.stream().map(TinkerPop::toResult).collect(Collectors.toList()));
        }
        if (object instanceof HashMap) {
            HashMap properties = (HashMap)object;
            Map<String, Result> data = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> TinkerPop.toResult(p.getValue())));
            return new Hash(data);
        }
        throw new IllegalStateException(String.format("type %s not accounted for", object.getClass().getName()));
    }

    public static <S, E, T> T withStartingVertices(Graph graph, Iterable<Map<String, Object>> ids, String sglQuery, Function<GraphTraversal<S, E>, T> operation) {
        return TinkerPop.withStartingVertices(graph, ids, sglQuery, Collections.emptyList(), operation);
    }

    public static <S, E, T> T withStartingVertices(Graph graph, Iterable<Map<String, Object>> ids, String sglQuery, List<Object> args, Function<GraphTraversal<S, E>, T> operation) {
        String uuid = UUID.randomUUID().toString();
        VertexArgs aux = TinkerPop.library(uuid, "null", "null", "null");
        org.apache.tinkerpop.gremlin.structure.Vertex auxVertex = graph.addVertex(aux.args);
        ids.forEach(id -> {
            GraphTraversal v = graph.traversal().V(new Object[]{id});
            if (v.hasNext()) {
                org.apache.tinkerpop.gremlin.structure.Vertex methodV = (org.apache.tinkerpop.gremlin.structure.Vertex)v.next();
                auxVertex.addEdge("depends_on", methodV, new Object[0]);
            }
        });
        GraphTraversal compile = SGL.compile(graph.traversal(), String.format("let %1$s = library(language: '%2$s') depends_on in %1$s %3$s", STARTING_VERTICES_START, uuid, sglQuery), args, ImmutableCompileConfig.builder().startingVertices(true));
        T result = operation.apply(compile);
        auxVertex.remove();
        return result;
    }

    private static <T> T getKey(org.apache.tinkerpop.gremlin.structure.Vertex v, String property, Class<T> c) {
        Object temp = ((LinkedHashMap)v.id()).get(property);
        if (temp == null) {
            return TinkerPop.getDefaultValue(c);
        }
        TinkerPop.checkBeforeCast(property, c, temp);
        return c.cast(temp);
    }

    private static <T> T getPropertyOrKey(org.apache.tinkerpop.gremlin.structure.Vertex v, String property, Class<T> c) {
        v.property(property);
        VertexProperty result = v.property(property);
        Object temp = !result.isPresent() ? TinkerPop.getKey(v, "_" + property, c) : result.value();
        if (temp == null) {
            return TinkerPop.getDefaultValue(c);
        }
        TinkerPop.checkBeforeCast(property, c, temp);
        return c.cast(temp);
    }

    private static <T> void checkBeforeCast(String property, Class<T> c, Object temp) {
        if (!c.isInstance(temp)) {
            throw new IllegalArgumentException(String.format("could not cast property %s from %s to %s", property, temp.getClass(), c));
        }
    }

    private static <T> T getDefaultValue(Class<T> c) {
        if (c.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(0);
        }
        if (c.isAssignableFrom(String.class)) {
            return (T)"";
        }
        if (c.isAssignableFrom(Instant.class)) {
            return (T)Instant.now();
        }
        throw new IllegalStateException("no default value for class " + c.getName());
    }

    public static class VertexArgs {
        public final Object[] args;
        public final Map<String, Object> id;

        public VertexArgs(Object[] args, Map<String, Object> id) {
            this.args = args;
            this.id = id;
        }
    }
}

