/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.trie.PatriciaTrie;

public class SubseqSet<T> {
    private final PatriciaTrie<Iterable<T>> prefixes = new PatriciaTrie();
    private final PatriciaTrie<Void> suffixes = new PatriciaTrie();

    public void add(Iterable<T> things) {
        if (this.contains(things)) {
            return;
        }
        List<T> ts = SubseqSet.reify(things);
        Optional<String> s = SubseqSet.encode(ts);
        if (!s.isPresent()) {
            return;
        }
        assert (ts.size() > 0);
        for (int i = 0; i < ts.size(); ++i) {
            SubseqSet.encode(ts.subList(0, i)).ifPresent(this::remove);
            SubseqSet.encode(ts.subList(i + 1, ts.size())).ifPresent(this::remove);
        }
        this.prefixes.put((Object)s.get(), things);
        this.suffixes.put((Object)SubseqSet.reverse(s.get()), null);
    }

    public boolean contains(Iterable<T> things) {
        ArrayList ts = Lists.newArrayList(things);
        Optional<String> s = SubseqSet.encode(ts);
        return s.filter(s1 -> !this.prefixes.prefixMap(s1).isEmpty()).isPresent() || s.filter(s1 -> !this.suffixes.prefixMap((Object)SubseqSet.reverse(s1)).isEmpty()).isPresent();
    }

    public Collection<Iterable<T>> all() {
        return this.prefixes.values();
    }

    private void remove(String prefixOrSuffix) {
        this.prefixes.remove((Object)prefixOrSuffix);
        this.suffixes.remove((Object)SubseqSet.reverse(prefixOrSuffix));
    }

    private static <T> List<T> reify(Iterable<T> things) {
        if (things instanceof List) {
            return (List)things;
        }
        return Lists.newArrayList(things);
    }

    private static <T> Optional<String> encode(Iterable<T> things) {
        return StreamSupport.stream(things.spliterator(), false).map(Object::toString).map(s -> s.replace("\u0000", "")).reduce((a, b) -> a + "\u0000" + b);
    }

    private static String reverse(String s) {
        return new StringBuilder(s).reverse().toString();
    }
}

