/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SCMAggregate {
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final Boolean admin;

    private SCMAggregate(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.admin = builder.admin;
    }

    @JsonCreator
    public SCMAggregate(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="admin") Boolean admin) {
        this.id = id;
        this.name = name;
        this.admin = admin;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAdmin() {
        if (this.admin == null) {
            throw new IllegalStateException("Didn't check for admin on this instance.");
        }
        return this.admin;
    }

    public static class Builder {
        private String name;
        private String id;
        private Boolean admin;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withAdmin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public SCMAggregate build() {
            return new SCMAggregate(this);
        }
    }
}

