/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.ruby;

import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.publicmethods.ruby.RubyMethodsVisitor;
import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.TypeInferencer;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.ListType;
import com.sourceclear.rubysonar.types.ModuleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.UnionType;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SClassNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;

public abstract class CallGraphVisitor
extends RubyMethodsVisitor {
    private final List<CallSite> callSites = new ArrayList<CallSite>();
    private Stack<String> methodsStack = new Stack();
    private final Path projectDir;
    private boolean isStatic = false;

    public CallGraphVisitor(Path projectDir) throws IOException {
        this.projectDir = projectDir.toRealPath(new LinkOption[0]);
    }

    @Override
    public Void visitSClassNode(SClassNode node) {
        boolean wasStatic = this.isStatic;
        this.isStatic = true;
        super.visitSClassNode(node);
        this.isStatic = wasStatic;
        return null;
    }

    @Override
    public Void visitDefnNode(DefnNode node) {
        String methodName = node.getName();
        State oldState = this.state;
        this.methodsStack.add(methodName);
        List methodBindings = this.state.lookup(methodName);
        if (methodBindings != null && !methodBindings.isEmpty()) {
            this.state = ((Binding)methodBindings.iterator().next()).type.getTable();
        }
        super.visitDefnNode(node);
        this.methodsStack.pop();
        this.state = oldState;
        return null;
    }

    @Override
    public Void visitDefsNode(DefsNode node) {
        String methodName = node.getName();
        this.methodsStack.add(methodName);
        super.visitDefsNode(node);
        this.methodsStack.pop();
        return null;
    }

    public Void visitCallNode(CallNode callNode) {
        Type receiverType = (Type)callNode.getReceiverNode().accept((NodeVisitor)new TypeInferencer(this.state));
        String calleeMethodName = callNode.getName();
        if ("new".equals(calleeMethodName)) {
            if (receiverType instanceof UnionType) {
                UnionType unionType = (UnionType)receiverType;
                for (Type type : unionType.getTypes()) {
                    if (!(type instanceof ClassType)) continue;
                    this.addCallSiteToConstructor((ClassType)type, callNode);
                }
            } else if (receiverType instanceof ClassType) {
                this.addCallSiteToConstructor((ClassType)receiverType, callNode);
            }
        } else if (receiverType instanceof UnionType) {
            UnionType unionType = (UnionType)receiverType;
            for (Type type : unionType.getTypes()) {
                this.addCallSiteToMethod(calleeMethodName, type, callNode);
            }
        } else {
            this.addCallSiteToMethod(calleeMethodName, receiverType, callNode);
        }
        return (Void)super.visitCallNode(callNode);
    }

    public Void visitFCallNode(FCallNode functionCallNode) {
        String name;
        switch (name = functionCallNode.getName().toString()) {
            case "include": 
            case "extend": 
            case "prepend": {
                Type argsType = (Type)functionCallNode.getArgsNode().accept((NodeVisitor)new TypeInferencer(this.state));
                if (!(argsType instanceof ListType)) break;
                ListType modules = (ListType)argsType;
                for (Type type : modules.getPositional()) {
                    if (!(type instanceof ModuleType)) continue;
                    this.addCallSiteToModuleCallback(functionCallNode, (ModuleType)type);
                }
                return (Void)super.visitFCallNode(functionCallNode);
            }
        }
        this.addCallSite((Node)functionCallNode);
        return (Void)super.visitFCallNode(functionCallNode);
    }

    private void addCallSiteToModuleCallback(FCallNode functionCallNode, ModuleType module) {
        String moduleName = module.getQname();
        String name = functionCallNode.getLexicalName();
        String callbackName = CallGraphVisitor.toPastTense(name);
        MethodInfoImpl methodInfo = new MethodInfoImpl(moduleName, null, callbackName, null);
        String file = this.projectDir.relativize(Paths.get(functionCallNode.getPosition().getFile(), new String[0])).toString();
        this.callSites.add(CallGraphVisitor.makeCallSite(this.callerMethod(), methodInfo, file, functionCallNode.getLine()));
    }

    static String toPastTense(String verb) {
        if (verb.endsWith("e")) {
            return verb + "d";
        }
        return verb + "ed";
    }

    public Void visitVCallNode(VCallNode functionCallNode) {
        this.addCallSite((Node)functionCallNode);
        return (Void)super.visitVCallNode(functionCallNode);
    }

    @Override
    protected Void defaultVisit(Node node) {
        for (Node child : node.childNodes()) {
            if (child == null) continue;
            child.accept((NodeVisitor)this);
        }
        return null;
    }

    private void addCallSiteToMethod(String methodName, Type receiverType, CallNode callNode) {
        Type calleeType = receiverType.getTable().lookupType(methodName);
        if (calleeType instanceof FunType) {
            this.addTypeAsCallSite(calleeType, (Node)callNode);
            return;
        }
        List calleeBindings = receiverType.getTable().lookupTagged(methodName, "class");
        if (calleeBindings == null) {
            return;
        }
        for (Binding calleeBinding : calleeBindings) {
            if (!(calleeBinding.type instanceof FunType)) continue;
            this.addTypeAsCallSite(calleeBinding.type, (Node)callNode);
        }
    }

    private void addCallSiteToConstructor(ClassType classType, CallNode callNode) {
        String moduleName = this.moduleNameFromType((Type)classType);
        MethodInfoImpl methodInfo = new MethodInfoImpl(moduleName, classType.getName(), "initialize", null);
        String file = this.projectDir.relativize(Paths.get(callNode.getPosition().getFile(), new String[0])).toString();
        this.callSites.add(CallGraphVisitor.makeCallSite(this.callerMethod(), methodInfo, file, callNode.getLine()));
    }

    private void addCallSite(Node functionCallNode) {
        if (functionCallNode instanceof INameNode) {
            String name = ((INameNode)functionCallNode).getName();
            List bindings = this.state.lookup(name);
            if (bindings == null && this.isStatic) {
                bindings = this.state.lookupTagged(name, "class");
            }
            if (bindings != null) {
                for (Binding binding : bindings) {
                    Type type = binding.type;
                    if (type instanceof UnionType) {
                        UnionType unionType = (UnionType)type;
                        for (Type t : unionType.getTypes()) {
                            this.addTypeAsCallSite(t, functionCallNode);
                        }
                        continue;
                    }
                    this.addTypeAsCallSite(type, functionCallNode);
                }
            }
        }
    }

    private void addTypeAsCallSite(Type type, Node functionCallNode) {
        if (type instanceof FunType) {
            boolean isNotBuiltinMethod;
            FunType funType = (FunType)type;
            boolean bl = isNotBuiltinMethod = funType.getMethodDefNode() != null;
            if (isNotBuiltinMethod) {
                MethodInfo callee = this.methodFromFunType(funType);
                String file = this.projectDir.relativize(Paths.get(functionCallNode.getPosition().getFile(), new String[0])).toString();
                this.callSites.add(CallGraphVisitor.makeCallSite(this.callerMethod(), callee, file, functionCallNode.getLine()));
            }
        }
    }

    @NotNull
    private MethodInfo methodFromFunType(FunType type) {
        String className;
        String moduleName = this.moduleNameFromType((Type)type);
        String calleeName = type.getMethodDefNode().getName();
        String string = className = type.getClassType() != null ? type.getClassType().getName() : null;
        if (moduleName == null && className == null) {
            className = "Object";
        }
        return MethodInfoImpl.builder().withModuleName(moduleName).withClassName(className).withMethodName(calleeName).build();
    }

    @Nullable
    private String moduleNameFromType(Type type) {
        State parent = type.getTable().getParent();
        String moduleName = null;
        if (parent != null) {
            if (parent.stateType == State.StateType.MODULE) {
                moduleName = parent.path;
            } else if (parent.stateType == State.StateType.CLASS) {
                moduleName = CallGraphVisitor.parentPath(parent.path);
            }
        }
        return moduleName;
    }

    private MethodInfo callerMethod() {
        return new MethodInfoImpl(this.currentModule(), this.currentClass(), this.currentMethod(), null);
    }

    @Nullable
    private String currentMethod() {
        if (this.methodsStack.isEmpty()) {
            return null;
        }
        return this.methodsStack.peek();
    }

    private static CallSite makeCallSite(MethodInfo caller, MethodInfo callee, String file, int lineNumber) {
        return new CallSite(caller, callee, file, lineNumber + 1);
    }

    public List<CallSite> getCallSites() {
        return this.callSites;
    }
}

