/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.java;

import com.google.common.base.Strings;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.CHACallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.java.Constants;
import com.sourceclear.methods.java.MethodInvocation;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class CallGraphBuilderMethodVisitor
extends MethodVisitor {
    private final MethodInfo caller;
    private int currentLine;
    private String currentLoadedString;
    private final String fileName;
    private final Set<CHACallSite> callSites;

    CallGraphBuilderMethodVisitor(int version, MethodInfo caller, Set<CHACallSite> callSites2) {
        super(version);
        this.caller = caller;
        this.fileName = this.toFileName(caller.getClassName());
        this.callSites = callSites2;
    }

    public void visitMethodInsn(int opcode, String receiver, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, receiver, name, desc, itf);
        MethodInvocation invocation = new MethodInvocation(opcode, MethodInfoImpl.builder().withClassName(receiver).withMethodName(name).withDesc(Utils.stripReturnType(desc)).build());
        if (invocation.equals(Constants.FOR_NAME_METHOD_INVOCATION) && !Strings.isNullOrEmpty((String)this.currentLoadedString)) {
            MethodInfo clinit = MethodInfoImpl.builder().withClassName(Utils.classNameToInternalName(this.currentLoadedString)).withMethodName("<clinit>").withDesc("()").build();
            CHACallSite callSite = new CHACallSite(this.caller, clinit, this.fileName, this.currentLine, CHACallSite.CallType.STATIC);
            this.callSites.add(callSite);
            return;
        }
        MethodInfo callee = MethodInfoImpl.builder().withClassName(receiver).withMethodName(name).withDesc(Utils.stripReturnType(desc)).build();
        CHACallSite callSite = opcode == 183 || opcode == 184 ? new CHACallSite(this.caller, callee, this.fileName, this.currentLine, CHACallSite.CallType.STATIC) : new CHACallSite(this.caller, callee, this.fileName, this.currentLine, CHACallSite.CallType.VIRTUAL);
        this.callSites.add(callSite);
    }

    public void visitLdcInsn(Object arg) {
        if (arg instanceof String) {
            this.currentLoadedString = (String)arg;
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
    }

    private String toFileName(String className) {
        return className + ".class";
    }
}

