/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import java.util.Objects;

public class CHACallSite
extends CallSite {
    @JsonProperty
    private final CallType callType;

    public CHACallSite(@JsonProperty(value="caller") MethodInfo caller, @JsonProperty(value="callee") MethodInfo callee, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="line_number") int lineNumber, @JsonProperty(value="call_type") CallType callType) {
        super(caller, callee, fileName, lineNumber);
        this.callType = callType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CHACallSite that = (CHACallSite)o;
        return this.callType == that.callType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.callType});
    }

    @Override
    public String toString() {
        return "CHACallSite{callType=" + (Object)((Object)this.callType) + ", " + super.toString() + "}";
    }

    public CallType getCallType() {
        return this.callType;
    }

    public CallSite toCallSite() {
        return new CallSite(this.getCaller(), this.getCallee(), this.getFileName(), this.getLineNumber());
    }

    public static enum CallType {
        STATIC,
        VIRTUAL;

    }
}

