/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.MavenModuleAwareScanBatcher;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.PermissiveEntryPointResolver;
import com.sourceclear.methods.VulnMethodsInput;
import com.veracode.security.logging.SecureLogger;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class ModuleAwareScanBatcher
extends MethodScanBatcher {
    private static final EntryPointResolver ENTRY_POINT_RESOLVER = new PermissiveEntryPointResolver();
    private static final SecureLogger LOGGER = SecureLogger.getLogger(MavenModuleAwareScanBatcher.class);
    private final MethodScannerFactory methodScannerFactory;
    private final LogStream logStream;
    private VulnMethodsInput input;

    ModuleAwareScanBatcher(MethodScannerFactory methodScannerFactory, LogStream logStream) {
        this.methodScannerFactory = methodScannerFactory;
        this.logStream = logStream;
    }

    @Override
    public final MethodScanBatcher.Result batch(Path scanRoot, Collection<MethodInfo> methods, VulnMethodsInput input) throws IOException {
        this.input = input;
        ModuleVisitor visitor2 = new ModuleVisitor(methods);
        Files.walkFileTree(scanRoot, visitor2);
        return new MethodScanBatcher.Result(visitor2.scanResult, visitor2.callGraphs);
    }

    abstract boolean isModuleDir(Path var1);

    abstract Path classesRelativePath();

    private class ModuleVisitor
    implements FileVisitor<Path> {
        private MethodScanner.VMReport scanResult = MethodScanner.VMReport.empty();
        private final Set<CallGraph> callGraphs = new HashSet<CallGraph>();
        private final Collection<MethodInfo> methods;
        private boolean inRoot = true;
        private String currentModule;

        private ModuleVisitor(Collection<MethodInfo> methods) {
            this.methods = Collections.unmodifiableCollection(methods);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            LOGGER.trace("preVisit: {}", (Object)dir);
            if (this.inRoot) {
                this.inRoot = false;
                return FileVisitResult.CONTINUE;
            }
            if (ModuleAwareScanBatcher.this.isModuleDir(dir)) {
                this.currentModule = dir.getFileName().toString();
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            LOGGER.trace("visit: {}", (Object)file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            LOGGER.trace("postVisit: {}", (Object)dir);
            if (exc != null) {
                LOGGER.info("exception while traversing file tree", exc);
            } else {
                Path classesDir = dir.resolve(ModuleAwareScanBatcher.this.classesRelativePath());
                if (Files.isDirectory(classesDir, new LinkOption[0])) {
                    FileTypeVisitor classFileVisitor = ClassFileVisitor.getVisitor();
                    Files.walkFileTree(classesDir, classFileVisitor);
                    ImmutableSet<Path> classFiles = classFileVisitor.getFiles();
                    String message = this.currentModule == null ? "Found " + classFiles.size() + " class files in " + classesDir + " for vulnerable method analysis." : "Vulnerable method analysis for module `" + this.currentModule + "`: scanning " + classFiles.size() + " class files.";
                    LOGGER.debug(message);
                    MethodScanner scanner = ModuleAwareScanBatcher.this.methodScannerFactory.withInput(ModuleAwareScanBatcher.this.input).forFiles((Collection<Path>)classFiles, this.methods, ENTRY_POINT_RESOLVER);
                    this.scanResult.combine(scanner.scan());
                    this.callGraphs.add(scanner.getCallGraph());
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

