/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.ModuleAwareScanBatcher;
import com.sourceclear.methods.MethodScannerFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

class GradleModuleAwareScanBatcher
extends ModuleAwareScanBatcher {
    private static Set<String> ignoreDirs = ImmutableSet.of((Object)"buildSrc");

    GradleModuleAwareScanBatcher(MethodScannerFactory methodScannerFactory, LogStream logStream) {
        super(methodScannerFactory, logStream);
    }

    @Override
    boolean isModuleDir(Path dir) {
        if (ignoreDirs.contains(dir.getFileName().toString())) {
            return false;
        }
        Path classesDir = this.classesRelativePath();
        return Files.isDirectory(dir.resolve(classesDir), new LinkOption[0]);
    }

    @Override
    Path classesRelativePath() {
        return Paths.get("build", "classes");
    }
}

