/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common.linecount;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.analysis.dotnet.Executable;
import com.sourceclear.api.client.Client;
import com.sourceclear.engine.common.DotNetConstants;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.ProjectDLLUtils;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.linecount.Counter;
import com.veracode.security.logging.SecureLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DotNetDLLCounter
implements Counter {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(DotNetDLLCounter.class);
    private final Client client;
    private ImmutableSet<Path> dllsFound;
    private Executable executable;

    public DotNetDLLCounter(Client client) {
        this.client = client;
    }

    @Override
    public boolean shouldCount(File projectRoot) throws IOException {
        StoredFileVisitor projectDLLVisitor = ProjectDLLUtils.visitorStartingAt(projectRoot.toPath());
        Files.walkFileTree(projectRoot.toPath(), projectDLLVisitor);
        this.dllsFound = projectDLLVisitor.getFiles();
        LOGGER.debug("project DLLs found: {}", (Object)this.dllsFound);
        return !this.dllsFound.isEmpty();
    }

    @Override
    @Nonnull
    public String getName() {
        return "DotNetDLLCounter";
    }

    @Override
    public long count(File projectRoot) throws IOException {
        this.executable = new Executable(this.client);
        Map<Path, Set<Path>> projectFolderToDLLs = this.organiseDLLsByProject(projectRoot);
        LOGGER.debug("projectFolderToDLLs: {}", (Object)projectFolderToDLLs);
        return projectFolderToDLLs.values().stream().mapToLong(this::averageLineCount).sum();
    }

    @VisibleForTesting
    Map<Path, Set<Path>> organiseDLLsByProject(File projectRoot) throws IOException {
        FileTypeVisitor fileTypeVisitor = new FileTypeVisitor((Set<String>)DotNetConstants.PROJECT_EXTENSIONS, (Set<String>)new HashSet<String>());
        Files.walkFileTree(projectRoot.toPath(), fileTypeVisitor);
        Set parentFolders = fileTypeVisitor.getFiles().stream().map(Path::getParent).collect(Collectors.toSet());
        return this.dllsFound.stream().map(dll -> parentFolders.stream().filter(dll::startsWith).findFirst().map(parent -> new AbstractMap.SimpleEntry<Path, Path>((Path)parent, (Path)dll)).orElse(new AbstractMap.SimpleEntry<Path, Path>((Path)dll, (Path)dll))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toSet())));
    }

    @VisibleForTesting
    long averageLineCount(Set<Path> dlls) {
        double avg = dlls.stream().mapToLong(this::countDLL).average().orElse(0.0);
        return Math.round(avg);
    }

    @VisibleForTesting
    long countDLL(Path dll) {
        try {
            return this.executable.countInstructions(dll);
        }
        catch (Exception ex) {
            LOGGER.debug("Exception occurred while attempting to count instructions for {}. Returning 0 as line count. ", (Object)dll, (Object)ex);
            return 0L;
        }
    }
}

