/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.util.io.IO;
import com.sourceclear.util.security.SecurityUtils;
import com.srcclr.sdk.LibraryGraphSerializer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public abstract class Plugin {
    private final String name;
    private final Client client;
    private String cache = null;

    public Plugin(String name) {
        this.name = name;
        boolean disableFips = false;
        String expandTlsEnv = System.getenv("SRCCLR_EXPAND_TLS");
        String fipsDisabledEnv = System.getenv("DISABLE_FIPS");
        if (StringUtils.isNotBlank((String)expandTlsEnv) && StringUtils.isBlank((String)fipsDisabledEnv)) {
            disableFips = Boolean.parseBoolean(expandTlsEnv);
        }
        if (StringUtils.isNotBlank((String)fipsDisabledEnv) && StringUtils.isBlank((String)expandTlsEnv)) {
            disableFips = Boolean.parseBoolean(fipsDisabledEnv);
        }
        if (Stream.of(expandTlsEnv, fipsDisabledEnv).allMatch(StringUtils::isNotBlank)) {
            disableFips = Boolean.parseBoolean(expandTlsEnv);
        }
        this.client = new SourceClearClient.Builder().withExpBackOffInitial(0).withBaseURI(URI.create("https://api.sourceclear.com")).withDisableFips(disableFips).build();
    }

    public Plugin(String name, Client client) {
        this.name = name;
        this.client = client;
    }

    public void ensurePresent() throws Exception {
        String version = this.determineVersion();
        if (!this.check()) {
            Path relative = this.destinationFilename(this.name, version);
            Path absolute = this.pluginDirectory().resolve(relative);
            Path parentDir = absolute.getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0]) && !parentDir.toFile().mkdirs()) {
                throw new IOException("failed to create directories");
            }
            IO.downloadFileIntoDir(this.downloadUrl(version), absolute.getFileName().toString(), parentDir.toFile(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), false);
            this.prepare(absolute);
            if (!this.check()) {
                throw new Exception("failed to fetch plugin '" + this.name + "'");
            }
        }
    }

    public final String envVar() {
        return String.format("SRCCLR_%s_VERSION", this.name.toUpperCase().replace('-', '_'));
    }

    @VisibleForTesting
    public Path pluginDirectory() throws IOException {
        String userHome = System.getProperty("user.home");
        return SecurityUtils.securePathsGet((String)userHome, (String[])new String[0]).toRealPath(new LinkOption[0]).resolve(".srcclr").resolve(this.name);
    }

    @VisibleForTesting
    public URL downloadUrl(String version) throws IOException {
        try {
            return new URL(String.format("https://download.sourceclear.com/%s/%s/%s", this.name, version, this.downloadFilename(this.name)));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    public String determineVersion() throws IOException {
        if (this.cache != null) {
            return this.cache;
        }
        String v = System.getenv(this.envVar());
        if (StringUtils.isBlank((String)v)) {
            try {
                v = this.client.getGenerationVersion(this.clientType(), this.generation());
            }
            catch (IOException e) {
                throw new IOException(String.format("Unable to determine plugin version of %s with generation = %s", new Object[]{this.clientType(), this.generation()}), e);
            }
        }
        this.cache = v;
        Plugin.whitelistVersion(this.cache);
        return this.cache;
    }

    public Path executable() throws IOException {
        return this.pluginDirectory().resolve(this.destinationFilename(this.name, this.determineVersion())).toAbsolutePath();
    }

    public abstract BuildSystemClientType clientType();

    public long generation() {
        return LibraryGraphSerializer.getCurrentGeneration();
    }

    public abstract String downloadFilename(String var1) throws IOException;

    public abstract Path destinationFilename(String var1, String var2) throws IOException;

    public void prepare(Path dest) {
    }

    public boolean check() throws IOException {
        return Files.exists(this.executable(), new LinkOption[0]);
    }

    private static void whitelistVersion(String version) {
        if (!version.replaceAll("[^a-z0-9.+-]", "").equals(version)) {
            throw new IllegalArgumentException("invalid plugin version supplied");
        }
    }
}

