/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.sourceclear.engine.common.StoredFileVisitor;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;

public class FilenameVisitor
extends StoredFileVisitor {
    private final Set<String> filenames;
    private final Set<String> ignoredDirectories;

    public FilenameVisitor(Set<String> filenames, Set<String> ignoredDirectories) {
        this.filenames = filenames;
        this.ignoredDirectories = ignoredDirectories;
    }

    @Override
    public Set<String> getFileTypesLookedFor() {
        return this.filenames;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return this.ignoredDirectories.contains(dir.getFileName().toString()) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        for (String filename : this.filenames) {
            if (!file.getFileName().endsWith(filename)) continue;
            this.files.add(file);
        }
        return FileVisitResult.CONTINUE;
    }
}

