/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.sourceclear.util.system.OS;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;

public class DirUtils {
    public static void copyDirectory(Path src, Path dest) throws IOException {
        if (!Files.exists(dest, new LinkOption[0])) {
            OS.createDirectories(dest, PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)));
        }
        DirectoryCopier directoryCopier = new DirectoryCopier(src, dest);
        Files.walkFileTree(src, directoryCopier);
    }

    private static class DirectoryCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;
        private static final CopyOption[] COPY_OPTIONS = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS};

        private DirectoryCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path newdir = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, newdir, COPY_OPTIONS);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            try {
                Files.copy(file, this.target.resolve(this.source.relativize(file)), COPY_OPTIONS);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (exc == null) {
                Path newdir = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(newdir, time);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

