/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Iterators;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.MethodModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"method", "callChains"})
@NotThreadSafe
public class MethodCallData
implements Iterable<CallChainModel> {
    @JsonProperty(value="method")
    private final MethodModel method;
    @JsonProperty(value="callChains")
    @JsonDeserialize(as=ArrayList.class)
    private Collection<CallChainModel> callChains;

    @JsonCreator
    public MethodCallData(@JsonProperty(value="method") MethodModel method, @JsonProperty(value="callChains") Collection<CallChainModel> callChains) {
        this.method = method;
        this.callChains = callChains;
    }

    public MethodCallData(MethodModel method) {
        this.method = method;
        this.callChains = new ArrayList<CallChainModel>();
    }

    public void addCallChain(CallChainModel callChain) {
        if (this.callChains == null) {
            this.callChains = new ArrayList<CallChainModel>();
        }
        this.callChains.add(callChain);
    }

    @Override
    public Iterator<CallChainModel> iterator() {
        return this.callChains != null ? Iterators.unmodifiableIterator(this.callChains.iterator()) : Collections.emptyIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodCallData that = (MethodCallData)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.callChains, that.callChains);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.callChains);
    }

    public String toString() {
        return "MethodCallData{method=" + this.method + ", callChains=" + this.callChains + '}';
    }

    public MethodModel getMethod() {
        return this.method;
    }

    public Collection<CallChainModel> getCallChains() {
        return Collections.unmodifiableCollection(this.callChains);
    }

    public int size() {
        return this.callChains.size();
    }
}

