/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.match.VeracodeScan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.annotation.Nullable;

abstract class VeracodeScan_Builder {
    private String accountId;
    @Nullable
    private String env = null;
    private String appId;
    private String appName;
    private long appVersion;
    private List<Evidence> evidence = ImmutableList.of();
    private UUID scanId;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    VeracodeScan_Builder() {
    }

    public static VeracodeScan.Builder from(VeracodeScan value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new VeracodeScan.Builder().mergeFrom(value);
    }

    @JsonProperty(value="accountId")
    public VeracodeScan.Builder setAccountId(String accountId) {
        this.accountId = Objects.requireNonNull(accountId);
        this._unsetProperties.remove((Object)Property.ACCOUNT_ID);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapAccountId(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setAccountId((String)mapper.apply(this.getAccountId()));
    }

    public String getAccountId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ACCOUNT_ID) ? 1 : 0) != 0, (Object)"accountId not set");
        return this.accountId;
    }

    @JsonProperty(value="env")
    public VeracodeScan.Builder setEnv(@Nullable String env) {
        this.env = env;
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapEnv(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        String env = this.getEnv();
        if (env != null) {
            this.setEnv((String)mapper.apply(env));
        }
        return (VeracodeScan.Builder)this;
    }

    @Nullable
    public String getEnv() {
        return this.env;
    }

    @JsonProperty(value="appId")
    public VeracodeScan.Builder setAppId(String appId) {
        this.appId = Objects.requireNonNull(appId);
        this._unsetProperties.remove((Object)Property.APP_ID);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapAppId(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setAppId((String)mapper.apply(this.getAppId()));
    }

    public String getAppId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.APP_ID) ? 1 : 0) != 0, (Object)"appId not set");
        return this.appId;
    }

    @JsonProperty(value="appName")
    public VeracodeScan.Builder setAppName(String appName) {
        this.appName = Objects.requireNonNull(appName);
        this._unsetProperties.remove((Object)Property.APP_NAME);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapAppName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setAppName((String)mapper.apply(this.getAppName()));
    }

    public String getAppName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.APP_NAME) ? 1 : 0) != 0, (Object)"appName not set");
        return this.appName;
    }

    @JsonProperty(value="appVersion")
    public VeracodeScan.Builder setAppVersion(long appVersion) {
        this.appVersion = appVersion;
        this._unsetProperties.remove((Object)Property.APP_VERSION);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapAppVersion(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setAppVersion(mapper.applyAsLong(this.getAppVersion()));
    }

    public long getAppVersion() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.APP_VERSION) ? 1 : 0) != 0, (Object)"appVersion not set");
        return this.appVersion;
    }

    public VeracodeScan.Builder addEvidence(Evidence element) {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        this.evidence.add(Objects.requireNonNull(element));
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder addEvidence(Evidence ... elements) {
        return this.addAllEvidence(Arrays.asList(elements));
    }

    public VeracodeScan.Builder addAllEvidence(Spliterator<? extends Evidence> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.evidence instanceof ImmutableList) {
                this.evidence = new ArrayList<Evidence>(this.evidence);
            }
            ((ArrayList)this.evidence).ensureCapacity(this.evidence.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addEvidence);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder addAllEvidence(BaseStream<? extends Evidence, ?> elements) {
        return this.addAllEvidence(elements.spliterator());
    }

    @JsonProperty(value="evidence")
    public VeracodeScan.Builder addAllEvidence(Iterable<? extends Evidence> elements) {
        return this.addAllEvidence(elements.spliterator());
    }

    public VeracodeScan.Builder mutateEvidence(Consumer<? super List<Evidence>> mutator) {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        mutator.accept(this.evidence);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder clearEvidence() {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = ImmutableList.of();
        } else {
            this.evidence.clear();
        }
        return (VeracodeScan.Builder)this;
    }

    public List<Evidence> getEvidence() {
        if (this.evidence instanceof ImmutableList) {
            this.evidence = new ArrayList<Evidence>(this.evidence);
        }
        return Collections.unmodifiableList(this.evidence);
    }

    @JsonProperty(value="scanId")
    public VeracodeScan.Builder setScanId(UUID scanId) {
        this.scanId = Objects.requireNonNull(scanId);
        this._unsetProperties.remove((Object)Property.SCAN_ID);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mapScanId(UnaryOperator<UUID> mapper) {
        Objects.requireNonNull(mapper);
        return this.setScanId((UUID)mapper.apply(this.getScanId()));
    }

    public UUID getScanId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.SCAN_ID) ? 1 : 0) != 0, (Object)"scanId not set");
        return this.scanId;
    }

    public VeracodeScan.Builder mergeFrom(VeracodeScan value) {
        VeracodeScan.Builder defaults = new VeracodeScan.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ACCOUNT_ID) || !Objects.equals(value.getAccountId(), ((VeracodeScan_Builder)defaults).getAccountId())) {
            this.setAccountId(value.getAccountId());
        }
        if (!Objects.equals(value.getEnv(), ((VeracodeScan_Builder)defaults).getEnv())) {
            this.setEnv(value.getEnv());
        }
        if (defaults._unsetProperties.contains((Object)Property.APP_ID) || !Objects.equals(value.getAppId(), ((VeracodeScan_Builder)defaults).getAppId())) {
            this.setAppId(value.getAppId());
        }
        if (defaults._unsetProperties.contains((Object)Property.APP_NAME) || !Objects.equals(value.getAppName(), ((VeracodeScan_Builder)defaults).getAppName())) {
            this.setAppName(value.getAppName());
        }
        if (defaults._unsetProperties.contains((Object)Property.APP_VERSION) || value.getAppVersion() != ((VeracodeScan_Builder)defaults).getAppVersion()) {
            this.setAppVersion(value.getAppVersion());
        }
        if (value instanceof Value && this.evidence == ImmutableList.of()) {
            this.evidence = ImmutableList.copyOf(value.getEvidence());
        } else {
            this.addAllEvidence(value.getEvidence());
        }
        if (defaults._unsetProperties.contains((Object)Property.SCAN_ID) || !Objects.equals(value.getScanId(), ((VeracodeScan_Builder)defaults).getScanId())) {
            this.setScanId(value.getScanId());
        }
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder mergeFrom(VeracodeScan.Builder template) {
        VeracodeScan.Builder base = template;
        VeracodeScan.Builder defaults = new VeracodeScan.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ACCOUNT_ID) || !defaults._unsetProperties.contains((Object)Property.ACCOUNT_ID) && Objects.equals(template.getAccountId(), ((VeracodeScan_Builder)defaults).getAccountId()))) {
            this.setAccountId(template.getAccountId());
        }
        if (!Objects.equals(template.getEnv(), ((VeracodeScan_Builder)defaults).getEnv())) {
            this.setEnv(template.getEnv());
        }
        if (!(base._unsetProperties.contains((Object)Property.APP_ID) || !defaults._unsetProperties.contains((Object)Property.APP_ID) && Objects.equals(template.getAppId(), ((VeracodeScan_Builder)defaults).getAppId()))) {
            this.setAppId(template.getAppId());
        }
        if (!(base._unsetProperties.contains((Object)Property.APP_NAME) || !defaults._unsetProperties.contains((Object)Property.APP_NAME) && Objects.equals(template.getAppName(), ((VeracodeScan_Builder)defaults).getAppName()))) {
            this.setAppName(template.getAppName());
        }
        if (!base._unsetProperties.contains((Object)Property.APP_VERSION) && (defaults._unsetProperties.contains((Object)Property.APP_VERSION) || template.getAppVersion() != ((VeracodeScan_Builder)defaults).getAppVersion())) {
            this.setAppVersion(template.getAppVersion());
        }
        this.addAllEvidence(base.evidence);
        if (!(base._unsetProperties.contains((Object)Property.SCAN_ID) || !defaults._unsetProperties.contains((Object)Property.SCAN_ID) && Objects.equals(template.getScanId(), ((VeracodeScan_Builder)defaults).getScanId()))) {
            this.setScanId(template.getScanId());
        }
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan.Builder clear() {
        VeracodeScan.Builder defaults = new VeracodeScan.Builder();
        this.accountId = defaults.accountId;
        this.env = defaults.env;
        this.appId = defaults.appId;
        this.appName = defaults.appName;
        this.appVersion = defaults.appVersion;
        this.clearEvidence();
        this.scanId = defaults.scanId;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (VeracodeScan.Builder)this;
    }

    public VeracodeScan build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public VeracodeScan buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String accountId;
        @Nullable
        private final String env;
        private final String appId;
        private final String appName;
        private final long appVersion;
        private final ImmutableList<Evidence> evidence;
        private final UUID scanId;
        private final EnumSet<Property> _unsetProperties;

        Partial(VeracodeScan_Builder builder) {
            this.accountId = builder.accountId;
            this.env = builder.env;
            this.appId = builder.appId;
            this.appName = builder.appName;
            this.appVersion = builder.appVersion;
            this.evidence = ImmutableList.copyOf((Collection)builder.evidence);
            this.scanId = builder.scanId;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="accountId")
        public String getAccountId() {
            if (this._unsetProperties.contains((Object)Property.ACCOUNT_ID)) {
                throw new UnsupportedOperationException("accountId not set");
            }
            return this.accountId;
        }

        @Override
        @JsonProperty(value="env")
        @Nullable
        public String getEnv() {
            return this.env;
        }

        @Override
        @JsonProperty(value="appId")
        public String getAppId() {
            if (this._unsetProperties.contains((Object)Property.APP_ID)) {
                throw new UnsupportedOperationException("appId not set");
            }
            return this.appId;
        }

        @Override
        @JsonProperty(value="appName")
        public String getAppName() {
            if (this._unsetProperties.contains((Object)Property.APP_NAME)) {
                throw new UnsupportedOperationException("appName not set");
            }
            return this.appName;
        }

        @Override
        @JsonProperty(value="appVersion")
        public long getAppVersion() {
            if (this._unsetProperties.contains((Object)Property.APP_VERSION)) {
                throw new UnsupportedOperationException("appVersion not set");
            }
            return this.appVersion;
        }

        @Override
        @JsonProperty(value="evidence")
        public List<Evidence> getEvidence() {
            return this.evidence;
        }

        @Override
        @JsonProperty(value="scanId")
        public UUID getScanId() {
            if (this._unsetProperties.contains((Object)Property.SCAN_ID)) {
                throw new UnsupportedOperationException("scanId not set");
            }
            return this.scanId;
        }

        @Override
        public VeracodeScan.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((VeracodeScan_Builder)builder).accountId = this.accountId;
            ((VeracodeScan_Builder)builder).env = this.env;
            ((VeracodeScan_Builder)builder).appId = this.appId;
            ((VeracodeScan_Builder)builder).appName = this.appName;
            ((VeracodeScan_Builder)builder).appVersion = this.appVersion;
            ((VeracodeScan_Builder)builder).evidence = this.evidence;
            ((VeracodeScan_Builder)builder).scanId = this.scanId;
            ((VeracodeScan_Builder)builder)._unsetProperties.clear();
            ((VeracodeScan_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.accountId, other.accountId) && Objects.equals(this.env, other.env) && Objects.equals(this.appId, other.appId) && Objects.equals(this.appName, other.appName) && this.appVersion == other.appVersion && Objects.equals(this.evidence, other.evidence) && Objects.equals(this.scanId, other.scanId) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.env, this.appId, this.appName, this.appVersion, this.evidence, this.scanId, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial VeracodeScan{");
            if (!this._unsetProperties.contains((Object)Property.ACCOUNT_ID)) {
                result.append("accountId=").append(this.accountId).append(", ");
            }
            if (this.env != null) {
                result.append("env=").append(this.env).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.APP_ID)) {
                result.append("appId=").append(this.appId).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.APP_NAME)) {
                result.append("appName=").append(this.appName).append(", ");
            }
            if (!this._unsetProperties.contains((Object)Property.APP_VERSION)) {
                result.append("appVersion=").append(this.appVersion).append(", ");
            }
            result.append("evidence=").append(this.evidence);
            if (!this._unsetProperties.contains((Object)Property.SCAN_ID)) {
                result.append(", scanId=").append(this.scanId);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends VeracodeScan.Builder {
            private PartialBuilder() {
            }

            @Override
            public VeracodeScan build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String accountId;
        @Nullable
        private final String env;
        private final String appId;
        private final String appName;
        private final long appVersion;
        private final ImmutableList<Evidence> evidence;
        private final UUID scanId;

        private Value(VeracodeScan_Builder builder) {
            this.accountId = builder.accountId;
            this.env = builder.env;
            this.appId = builder.appId;
            this.appName = builder.appName;
            this.appVersion = builder.appVersion;
            this.evidence = ImmutableList.copyOf((Collection)builder.evidence);
            this.scanId = builder.scanId;
        }

        @Override
        @JsonProperty(value="accountId")
        public String getAccountId() {
            return this.accountId;
        }

        @Override
        @JsonProperty(value="env")
        @Nullable
        public String getEnv() {
            return this.env;
        }

        @Override
        @JsonProperty(value="appId")
        public String getAppId() {
            return this.appId;
        }

        @Override
        @JsonProperty(value="appName")
        public String getAppName() {
            return this.appName;
        }

        @Override
        @JsonProperty(value="appVersion")
        public long getAppVersion() {
            return this.appVersion;
        }

        @Override
        @JsonProperty(value="evidence")
        public List<Evidence> getEvidence() {
            return this.evidence;
        }

        @Override
        @JsonProperty(value="scanId")
        public UUID getScanId() {
            return this.scanId;
        }

        @Override
        public VeracodeScan.Builder toBuilder() {
            VeracodeScan.Builder builder = new VeracodeScan.Builder();
            ((VeracodeScan_Builder)builder).accountId = this.accountId;
            ((VeracodeScan_Builder)builder).env = this.env;
            ((VeracodeScan_Builder)builder).appId = this.appId;
            ((VeracodeScan_Builder)builder).appName = this.appName;
            ((VeracodeScan_Builder)builder).appVersion = this.appVersion;
            ((VeracodeScan_Builder)builder).evidence = this.evidence;
            ((VeracodeScan_Builder)builder).scanId = this.scanId;
            ((VeracodeScan_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.accountId, other.accountId) && Objects.equals(this.env, other.env) && Objects.equals(this.appId, other.appId) && Objects.equals(this.appName, other.appName) && this.appVersion == other.appVersion && Objects.equals(this.evidence, other.evidence) && Objects.equals(this.scanId, other.scanId);
        }

        public int hashCode() {
            return Objects.hash(this.accountId, this.env, this.appId, this.appName, this.appVersion, this.evidence, this.scanId);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("VeracodeScan{accountId=").append(this.accountId);
            if (this.env != null) {
                result.append(", env=").append(this.env);
            }
            return result.append(", appId=").append(this.appId).append(", appName=").append(this.appName).append(", appVersion=").append(this.appVersion).append(", evidence=").append(this.evidence).append(", scanId=").append(this.scanId).append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements VeracodeScan {
        private Rebuildable() {
        }

        public abstract VeracodeScan.Builder toBuilder();
    }

    private static enum Property {
        ACCOUNT_ID("accountId"),
        APP_ID("appId"),
        APP_NAME("appName"),
        APP_VERSION("appVersion"),
        SCAN_ID("scanId");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

