/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.sourceclear.api.data.ScanType;
import java.util.Objects;

public interface MatchValidations {
    public ScanType getScanType();

    public String getContainerName();

    public String getContainerTag();

    public boolean isVulnMethods();

    public String getBranch();

    public String getRepoUrl();

    public String getCommitHash();

    default public void validate() {
        switch (this.getScanType()) {
            case REPO: {
                if (this.getContainerName() == null && this.getContainerTag() == null) break;
                throw new IllegalArgumentException("container should not be specified for a repository scan");
            }
            case CONTAINER: {
                if (this.isVulnMethods()) {
                    throw new IllegalArgumentException("source-level concepts such as vulnerable methods are inapplicable to container scans");
                }
                if (this.getBranch() != null || this.getRepoUrl() != null || this.getCommitHash() != null) {
                    throw new IllegalArgumentException("git metadata is inapplicable to container scans");
                }
                Objects.requireNonNull(this.getContainerName(), "container name not given in container scan");
                Objects.requireNonNull(this.getContainerTag(), "container tag not given in container scan");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

