/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.HATEOASApiModel;
import com.sourceclear.api.data.Link;
import com.sourceclear.api.data.ScanType;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.match.ConsoleUploadStatus;
import com.sourceclear.api.data.match.MatchQuery;
import com.sourceclear.api.data.match.MatchValidations;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MatchResponse
extends HATEOASApiModel
implements MatchValidations {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="scanId")
    private String scanId;
    @JsonProperty(value="projectName")
    private String projectName;
    @JsonProperty(value="organization")
    private String organization;
    @JsonProperty(value="scanType")
    private ScanType scanType;
    @JsonProperty(value="commitHash")
    private String commitHash;
    @JsonProperty(value="repoUrl")
    private String repoUrl;
    @JsonProperty(value="consoleUploadStatus")
    private ConsoleUploadStatus consoleUploadStatus;
    @JsonProperty(value="vulnMethods")
    private boolean vulnMethods;
    @JsonProperty(value="containerName")
    private String containerName;
    @JsonProperty(value="containerTag")
    private String containerTag;
    @JsonProperty(value="branch")
    private String branch;
    @JsonProperty(value="components")
    private List<LibraryMatchWithArtifactsApiModel> components = new ArrayList<LibraryMatchWithArtifactsApiModel>();

    public MatchResponse() {
    }

    public MatchResponse(Builder builder) {
        this.scanId = builder.scanId;
        this.organization = builder.organization;
        this.commitHash = builder.commitHash;
        this.repoUrl = builder.repoUrl;
        this.consoleUploadStatus = builder.consoleUploadStatus;
        this.vulnMethods = builder.vulnMethods;
        this.branch = builder.branch;
        this.components = builder.components;
        this.containerName = builder.containerName;
        this.containerTag = builder.containerTag;
        for (Link link : builder.links) {
            this.addLink(link);
        }
        this.scanType = builder.scanType;
        if (this.scanType == null) {
            this.scanType = ScanType.REPO;
        }
        this.validate();
    }

    public int countVulnerableComponents() {
        HashSet<Long> ids = new HashSet<Long>();
        for (LibraryMatchWithArtifactsApiModel libraryModel : this.components) {
            for (LibraryArtifactApiModel artifact : libraryModel.getArtifacts()) {
                ids.add(artifact.getId());
            }
        }
        return ids.size();
    }

    public String getScanId() {
        return this.scanId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getOrganization() {
        return this.organization;
    }

    @Override
    public String getCommitHash() {
        return this.commitHash;
    }

    @Override
    public String getRepoUrl() {
        return this.repoUrl;
    }

    public ConsoleUploadStatus getConsoleUploadStatus() {
        return this.consoleUploadStatus;
    }

    @Override
    public boolean isVulnMethods() {
        return this.vulnMethods;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    public List<LibraryMatchWithArtifactsApiModel> getComponents() {
        return this.components;
    }

    @Override
    public ScanType getScanType() {
        return this.scanType;
    }

    @Override
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public String getContainerTag() {
        return this.containerTag;
    }

    public static class Builder {
        private String scanId;
        private String organization;
        private String commitHash;
        private String repoUrl;
        private ScanType scanType;
        private String containerName;
        private String containerTag;
        private ConsoleUploadStatus consoleUploadStatus;
        private boolean vulnMethods = false;
        private String branch;
        private List<LibraryMatchWithArtifactsApiModel> components = new ArrayList<LibraryMatchWithArtifactsApiModel>();
        private List<Link> links = new ArrayList<Link>();

        public Builder fromMatchQuery(MatchQuery matchQuery) {
            this.scanId = matchQuery.getScanId();
            this.scanType = matchQuery.getScanType();
            this.organization = matchQuery.getOrganization();
            if (this.scanType == null) {
                this.scanType = ScanType.REPO;
            }
            switch (this.scanType) {
                case REPO: {
                    this.commitHash = matchQuery.getCommitHash();
                    this.repoUrl = matchQuery.getRepoUrl();
                    this.vulnMethods = matchQuery.isVulnMethods();
                    this.branch = matchQuery.getBranch();
                    break;
                }
                case CONTAINER: {
                    this.containerName = matchQuery.getContainerName();
                    this.containerTag = matchQuery.getContainerTag();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return this;
        }

        public Builder withScanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public Builder withOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder withCommitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        public Builder withRepoUrl(String repoUrl) {
            this.repoUrl = repoUrl;
            return this;
        }

        public Builder withConsoleUploadStatus(ConsoleUploadStatus consoleUploadStatus) {
            this.consoleUploadStatus = consoleUploadStatus;
            return this;
        }

        public Builder requestVulnMethods(boolean vulnMethods) {
            this.vulnMethods = vulnMethods;
            return this;
        }

        public Builder withContainer(String name, String tag) {
            this.containerName = name;
            this.containerTag = tag;
            return this;
        }

        public Builder withBranch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder withComponents(List<LibraryMatchWithArtifactsApiModel> components) {
            this.components = components;
            return this;
        }

        public Builder withLink(Link link) {
            this.links.add(link);
            return this;
        }

        public MatchResponse build() {
            return new MatchResponse(this);
        }
    }
}

