/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.api.data.evidence.Coordinates;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EvidencePath
implements Comparable<EvidencePath> {
    @JsonProperty(value="filePath")
    private String filePath;
    @JsonProperty(value="lineNumber")
    private Integer lineNumber;
    @JsonProperty(value="dependencyPath")
    private List<Coordinates> dependencyPath = new LinkedList<Coordinates>();
    private final String sep;

    public EvidencePath() {
        this.sep = File.separator;
    }

    @VisibleForTesting
    public EvidencePath(String filePath, Integer lineNumber, String fileSeparator) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.sep = fileSeparator;
    }

    public EvidencePath(String filePath, Integer lineNumber) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.sep = File.separator;
    }

    public EvidencePath(String filePath, Integer lineNumber, List<Coordinates> dependencyPath) {
        this.filePath = filePath;
        this.lineNumber = lineNumber;
        this.dependencyPath = dependencyPath;
        this.sep = File.separator;
    }

    @JsonIgnore
    public String getFilePathWithLineNumber() {
        return this.lineNumber != null ? this.filePath + "#L" + this.lineNumber : this.filePath;
    }

    @Override
    public int compareTo(@NotNull EvidencePath o2) {
        String sep = this.sep;
        if ("\\".equals(sep)) {
            sep = "\\\\";
        }
        List<Coordinates> path1 = this.getDependencyPath();
        List<Coordinates> path2 = o2.getDependencyPath();
        int res = Integer.compare(path1.size(), path2.size());
        if (res != 0) {
            return res;
        }
        String filePath1 = this.getFilePath();
        String filePath2 = o2.getFilePath();
        if (filePath1 != null && filePath2 != null && (res = Integer.compare(filePath1.split(sep).length, filePath2.split(sep).length)) != 0) {
            return res;
        }
        if (!path1.isEmpty()) {
            for (int i = 0; i < path1.size(); ++i) {
                res = path1.get(i).compareTo(path2.get(i));
                if (res == 0) continue;
                return res;
            }
        }
        if (filePath1 != null && filePath2 != null && (res = filePath1.compareTo(filePath2)) != 0) {
            return res;
        }
        return 0;
    }

    public String toString() {
        return "EvidencePath{filePath='" + this.filePath + '\'' + ", lineNumber=" + this.lineNumber + ", dependencyPath=" + this.dependencyPath + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvidencePath)) {
            return false;
        }
        EvidencePath that = (EvidencePath)o;
        return Objects.equals(this.getFilePath(), that.getFilePath()) && Objects.equals(this.getLineNumber(), that.getLineNumber()) && Objects.equals(this.getDependencyPath(), that.getDependencyPath());
    }

    public int hashCode() {
        return Objects.hash(this.getFilePath(), this.getLineNumber(), this.getDependencyPath());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public List<Coordinates> getDependencyPath() {
        return this.dependencyPath;
    }
}

