/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.ScanSuccessEvent;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class ScanSuccessEvent_ScanModel_Builder {
    private long id;
    private String commit = null;
    private String branch = null;
    private String tag = null;
    private URI reportLink;
    private int vulnIssuesCount;
    private int outofDateIssuesCount;
    private int licenseIssuesCount;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    ScanSuccessEvent_ScanModel_Builder() {
    }

    public static ScanSuccessEvent.ScanModel.Builder from(ScanSuccessEvent.ScanModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new ScanSuccessEvent.ScanModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public ScanSuccessEvent.ScanModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    public ScanSuccessEvent.ScanModel.Builder setCommit(String commit) {
        this.commit = Objects.requireNonNull(commit);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="commit")
    public ScanSuccessEvent.ScanModel.Builder setCommit(Optional<? extends String> commit) {
        if (commit.isPresent()) {
            return this.setCommit(commit.get());
        }
        return this.clearCommit();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableCommit(@Nullable String commit) {
        if (commit != null) {
            return this.setCommit(commit);
        }
        return this.clearCommit();
    }

    public ScanSuccessEvent.ScanModel.Builder mapCommit(UnaryOperator<String> mapper) {
        return this.setCommit(this.getCommit().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearCommit() {
        this.commit = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getCommit() {
        return Optional.ofNullable(this.commit);
    }

    public ScanSuccessEvent.ScanModel.Builder setBranch(String branch) {
        this.branch = Objects.requireNonNull(branch);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="branch")
    public ScanSuccessEvent.ScanModel.Builder setBranch(Optional<? extends String> branch) {
        if (branch.isPresent()) {
            return this.setBranch(branch.get());
        }
        return this.clearBranch();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableBranch(@Nullable String branch) {
        if (branch != null) {
            return this.setBranch(branch);
        }
        return this.clearBranch();
    }

    public ScanSuccessEvent.ScanModel.Builder mapBranch(UnaryOperator<String> mapper) {
        return this.setBranch(this.getBranch().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearBranch() {
        this.branch = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    public ScanSuccessEvent.ScanModel.Builder setTag(String tag) {
        this.tag = Objects.requireNonNull(tag);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="tag")
    public ScanSuccessEvent.ScanModel.Builder setTag(Optional<? extends String> tag) {
        if (tag.isPresent()) {
            return this.setTag(tag.get());
        }
        return this.clearTag();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableTag(@Nullable String tag) {
        if (tag != null) {
            return this.setTag(tag);
        }
        return this.clearTag();
    }

    public ScanSuccessEvent.ScanModel.Builder mapTag(UnaryOperator<String> mapper) {
        return this.setTag(this.getTag().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearTag() {
        this.tag = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @JsonProperty(value="reportLink")
    public ScanSuccessEvent.ScanModel.Builder setReportLink(URI reportLink) {
        this.reportLink = Objects.requireNonNull(reportLink);
        this._unsetProperties.remove((Object)Property.REPORT_LINK);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapReportLink(UnaryOperator<URI> mapper) {
        Objects.requireNonNull(mapper);
        return this.setReportLink((URI)mapper.apply(this.getReportLink()));
    }

    public URI getReportLink() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.REPORT_LINK) ? 1 : 0) != 0, (Object)"reportLink not set");
        return this.reportLink;
    }

    @JsonProperty(value="vulnIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setVulnIssuesCount(int vulnIssuesCount) {
        this.vulnIssuesCount = vulnIssuesCount;
        this._unsetProperties.remove((Object)Property.VULN_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapVulnIssuesCount(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setVulnIssuesCount(mapper.applyAsInt(this.getVulnIssuesCount()));
    }

    public int getVulnIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"vulnIssuesCount not set");
        return this.vulnIssuesCount;
    }

    @JsonProperty(value="outofDateIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setOutofDateIssuesCount(int outofDateIssuesCount) {
        this.outofDateIssuesCount = outofDateIssuesCount;
        this._unsetProperties.remove((Object)Property.OUTOF_DATE_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapOutofDateIssuesCount(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setOutofDateIssuesCount(mapper.applyAsInt(this.getOutofDateIssuesCount()));
    }

    public int getOutofDateIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"outofDateIssuesCount not set");
        return this.outofDateIssuesCount;
    }

    @JsonProperty(value="licenseIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setLicenseIssuesCount(int licenseIssuesCount) {
        this.licenseIssuesCount = licenseIssuesCount;
        this._unsetProperties.remove((Object)Property.LICENSE_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapLicenseIssuesCount(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setLicenseIssuesCount(mapper.applyAsInt(this.getLicenseIssuesCount()));
    }

    public int getLicenseIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"licenseIssuesCount not set");
        return this.licenseIssuesCount;
    }

    public ScanSuccessEvent.ScanModel.Builder mergeFrom(ScanSuccessEvent.ScanModel value) {
        ScanSuccessEvent.ScanModel.Builder defaults = new ScanSuccessEvent.ScanModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        value.getCommit().ifPresent(this::setCommit);
        value.getBranch().ifPresent(this::setBranch);
        value.getTag().ifPresent(this::setTag);
        if (defaults._unsetProperties.contains((Object)Property.REPORT_LINK) || !Objects.equals(value.getReportLink(), ((ScanSuccessEvent_ScanModel_Builder)defaults).getReportLink())) {
            this.setReportLink(value.getReportLink());
        }
        if (defaults._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) || value.getVulnIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getVulnIssuesCount()) {
            this.setVulnIssuesCount(value.getVulnIssuesCount());
        }
        if (defaults._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) || value.getOutofDateIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getOutofDateIssuesCount()) {
            this.setOutofDateIssuesCount(value.getOutofDateIssuesCount());
        }
        if (defaults._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) || value.getLicenseIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getLicenseIssuesCount()) {
            this.setLicenseIssuesCount(value.getLicenseIssuesCount());
        }
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mergeFrom(ScanSuccessEvent.ScanModel.Builder template) {
        ScanSuccessEvent.ScanModel.Builder base = template;
        ScanSuccessEvent.ScanModel.Builder defaults = new ScanSuccessEvent.ScanModel.Builder();
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        template.getCommit().ifPresent(this::setCommit);
        template.getBranch().ifPresent(this::setBranch);
        template.getTag().ifPresent(this::setTag);
        if (!(base._unsetProperties.contains((Object)Property.REPORT_LINK) || !defaults._unsetProperties.contains((Object)Property.REPORT_LINK) && Objects.equals(template.getReportLink(), ((ScanSuccessEvent_ScanModel_Builder)defaults).getReportLink()))) {
            this.setReportLink(template.getReportLink());
        }
        if (!base._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) && (defaults._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) || template.getVulnIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getVulnIssuesCount())) {
            this.setVulnIssuesCount(template.getVulnIssuesCount());
        }
        if (!base._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) && (defaults._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) || template.getOutofDateIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getOutofDateIssuesCount())) {
            this.setOutofDateIssuesCount(template.getOutofDateIssuesCount());
        }
        if (!base._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) && (defaults._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) || template.getLicenseIssuesCount() != ((ScanSuccessEvent_ScanModel_Builder)defaults).getLicenseIssuesCount())) {
            this.setLicenseIssuesCount(template.getLicenseIssuesCount());
        }
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder clear() {
        ScanSuccessEvent.ScanModel.Builder defaults = new ScanSuccessEvent.ScanModel.Builder();
        this.id = defaults.id;
        this.commit = defaults.commit;
        this.branch = defaults.branch;
        this.tag = defaults.tag;
        this.reportLink = defaults.reportLink;
        this.vulnIssuesCount = defaults.vulnIssuesCount;
        this.outofDateIssuesCount = defaults.outofDateIssuesCount;
        this.licenseIssuesCount = defaults.licenseIssuesCount;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public ScanSuccessEvent.ScanModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final long id;
        private final String commit;
        private final String branch;
        private final String tag;
        private final URI reportLink;
        private final int vulnIssuesCount;
        private final int outofDateIssuesCount;
        private final int licenseIssuesCount;
        private final EnumSet<Property> _unsetProperties;

        Partial(ScanSuccessEvent_ScanModel_Builder builder) {
            this.id = builder.id;
            this.commit = builder.commit;
            this.branch = builder.branch;
            this.tag = builder.tag;
            this.reportLink = builder.reportLink;
            this.vulnIssuesCount = builder.vulnIssuesCount;
            this.outofDateIssuesCount = builder.outofDateIssuesCount;
            this.licenseIssuesCount = builder.licenseIssuesCount;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="commit")
        public Optional<String> getCommit() {
            return Optional.ofNullable(this.commit);
        }

        @Override
        @JsonProperty(value="branch")
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        @JsonProperty(value="tag")
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        @Override
        @JsonProperty(value="reportLink")
        public URI getReportLink() {
            if (this._unsetProperties.contains((Object)Property.REPORT_LINK)) {
                throw new UnsupportedOperationException("reportLink not set");
            }
            return this.reportLink;
        }

        @Override
        @JsonProperty(value="vulnIssuesCount")
        public int getVulnIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("vulnIssuesCount not set");
            }
            return this.vulnIssuesCount;
        }

        @Override
        @JsonProperty(value="outofDateIssuesCount")
        public int getOutofDateIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("outofDateIssuesCount not set");
            }
            return this.outofDateIssuesCount;
        }

        @Override
        @JsonProperty(value="licenseIssuesCount")
        public int getLicenseIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("licenseIssuesCount not set");
            }
            return this.licenseIssuesCount;
        }

        @Override
        public ScanSuccessEvent.ScanModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((ScanSuccessEvent_ScanModel_Builder)builder).id = this.id;
            ((ScanSuccessEvent_ScanModel_Builder)builder).commit = this.commit;
            ((ScanSuccessEvent_ScanModel_Builder)builder).branch = this.branch;
            ((ScanSuccessEvent_ScanModel_Builder)builder).tag = this.tag;
            ((ScanSuccessEvent_ScanModel_Builder)builder).reportLink = this.reportLink;
            ((ScanSuccessEvent_ScanModel_Builder)builder).vulnIssuesCount = this.vulnIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder).outofDateIssuesCount = this.outofDateIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder).licenseIssuesCount = this.licenseIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder)._unsetProperties.clear();
            ((ScanSuccessEvent_ScanModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.id == other.id && Objects.equals(this.commit, other.commit) && Objects.equals(this.branch, other.branch) && Objects.equals(this.tag, other.tag) && Objects.equals(this.reportLink, other.reportLink) && this.vulnIssuesCount == other.vulnIssuesCount && this.outofDateIssuesCount == other.outofDateIssuesCount && this.licenseIssuesCount == other.licenseIssuesCount && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.commit, this.branch, this.tag, this.reportLink, this.vulnIssuesCount, this.outofDateIssuesCount, this.licenseIssuesCount, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial ScanModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append("id=").append(this.id);
                separator = ", ";
            }
            if (this.commit != null) {
                result.append(separator).append("commit=").append(this.commit);
                separator = ", ";
            }
            if (this.branch != null) {
                result.append(separator).append("branch=").append(this.branch);
                separator = ", ";
            }
            if (this.tag != null) {
                result.append(separator).append("tag=").append(this.tag);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.REPORT_LINK)) {
                result.append(separator).append("reportLink=").append(this.reportLink);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT)) {
                result.append(separator).append("vulnIssuesCount=").append(this.vulnIssuesCount);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT)) {
                result.append(separator).append("outofDateIssuesCount=").append(this.outofDateIssuesCount);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT)) {
                result.append(separator).append("licenseIssuesCount=").append(this.licenseIssuesCount);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends ScanSuccessEvent.ScanModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public ScanSuccessEvent.ScanModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final long id;
        private final String commit;
        private final String branch;
        private final String tag;
        private final URI reportLink;
        private final int vulnIssuesCount;
        private final int outofDateIssuesCount;
        private final int licenseIssuesCount;

        private Value(ScanSuccessEvent_ScanModel_Builder builder) {
            this.id = builder.id;
            this.commit = builder.commit;
            this.branch = builder.branch;
            this.tag = builder.tag;
            this.reportLink = builder.reportLink;
            this.vulnIssuesCount = builder.vulnIssuesCount;
            this.outofDateIssuesCount = builder.outofDateIssuesCount;
            this.licenseIssuesCount = builder.licenseIssuesCount;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="commit")
        public Optional<String> getCommit() {
            return Optional.ofNullable(this.commit);
        }

        @Override
        @JsonProperty(value="branch")
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        @JsonProperty(value="tag")
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        @Override
        @JsonProperty(value="reportLink")
        public URI getReportLink() {
            return this.reportLink;
        }

        @Override
        @JsonProperty(value="vulnIssuesCount")
        public int getVulnIssuesCount() {
            return this.vulnIssuesCount;
        }

        @Override
        @JsonProperty(value="outofDateIssuesCount")
        public int getOutofDateIssuesCount() {
            return this.outofDateIssuesCount;
        }

        @Override
        @JsonProperty(value="licenseIssuesCount")
        public int getLicenseIssuesCount() {
            return this.licenseIssuesCount;
        }

        @Override
        public ScanSuccessEvent.ScanModel.Builder toBuilder() {
            ScanSuccessEvent.ScanModel.Builder builder = new ScanSuccessEvent.ScanModel.Builder();
            ((ScanSuccessEvent_ScanModel_Builder)builder).id = this.id;
            ((ScanSuccessEvent_ScanModel_Builder)builder).commit = this.commit;
            ((ScanSuccessEvent_ScanModel_Builder)builder).branch = this.branch;
            ((ScanSuccessEvent_ScanModel_Builder)builder).tag = this.tag;
            ((ScanSuccessEvent_ScanModel_Builder)builder).reportLink = this.reportLink;
            ((ScanSuccessEvent_ScanModel_Builder)builder).vulnIssuesCount = this.vulnIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder).outofDateIssuesCount = this.outofDateIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder).licenseIssuesCount = this.licenseIssuesCount;
            ((ScanSuccessEvent_ScanModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.id == other.id && Objects.equals(this.commit, other.commit) && Objects.equals(this.branch, other.branch) && Objects.equals(this.tag, other.tag) && Objects.equals(this.reportLink, other.reportLink) && this.vulnIssuesCount == other.vulnIssuesCount && this.outofDateIssuesCount == other.outofDateIssuesCount && this.licenseIssuesCount == other.licenseIssuesCount;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.commit, this.branch, this.tag, this.reportLink, this.vulnIssuesCount, this.outofDateIssuesCount, this.licenseIssuesCount);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("ScanModel{id=").append(this.id);
            if (this.commit != null) {
                result.append(", commit=").append(this.commit);
            }
            if (this.branch != null) {
                result.append(", branch=").append(this.branch);
            }
            if (this.tag != null) {
                result.append(", tag=").append(this.tag);
            }
            return result.append(", reportLink=").append(this.reportLink).append(", vulnIssuesCount=").append(this.vulnIssuesCount).append(", outofDateIssuesCount=").append(this.outofDateIssuesCount).append(", licenseIssuesCount=").append(this.licenseIssuesCount).append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements ScanSuccessEvent.ScanModel {
        private Rebuildable() {
        }

        public abstract ScanSuccessEvent.ScanModel.Builder toBuilder();
    }

    private static enum Property {
        ID("id"),
        REPORT_LINK("reportLink"),
        VULN_ISSUES_COUNT("vulnIssuesCount"),
        OUTOF_DATE_ISSUES_COUNT("outofDateIssuesCount"),
        LICENSE_ISSUES_COUNT("licenseIssuesCount");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

