/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.PlanType;
import com.sourceclear.api.data.events.OrgModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class OrgModel_Builder {
    private long id;
    @Nullable
    private OrgModel.Type type = null;
    private String name;
    private PlanType planType;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    OrgModel_Builder() {
    }

    public static OrgModel.Builder from(OrgModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new OrgModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public OrgModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="type")
    public OrgModel.Builder setType(@Nullable OrgModel.Type type) {
        this.type = type;
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapType(UnaryOperator<OrgModel.Type> mapper) {
        Objects.requireNonNull(mapper);
        OrgModel.Type type = this.getType();
        if (type != null) {
            this.setType((OrgModel.Type)((Object)mapper.apply(type)));
        }
        return (OrgModel.Builder)this;
    }

    @Nullable
    public OrgModel.Type getType() {
        return this.type;
    }

    @JsonProperty(value="name")
    public OrgModel.Builder setName(String name) {
        this.name = Objects.requireNonNull(name);
        this._unsetProperties.remove((Object)Property.NAME);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapName(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setName((String)mapper.apply(this.getName()));
    }

    public String getName() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.NAME) ? 1 : 0) != 0, (Object)"name not set");
        return this.name;
    }

    @JsonProperty(value="planType")
    public OrgModel.Builder setPlanType(PlanType planType) {
        this.planType = Objects.requireNonNull(planType);
        this._unsetProperties.remove((Object)Property.PLAN_TYPE);
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mapPlanType(UnaryOperator<PlanType> mapper) {
        Objects.requireNonNull(mapper);
        return this.setPlanType((PlanType)((Object)mapper.apply(this.getPlanType())));
    }

    public PlanType getPlanType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.PLAN_TYPE) ? 1 : 0) != 0, (Object)"planType not set");
        return this.planType;
    }

    public OrgModel.Builder mergeFrom(OrgModel value) {
        OrgModel.Builder defaults = new OrgModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((OrgModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        if (!Objects.equals((Object)value.getType(), (Object)((OrgModel_Builder)defaults).getType())) {
            this.setType(value.getType());
        }
        if (defaults._unsetProperties.contains((Object)Property.NAME) || !Objects.equals(value.getName(), ((OrgModel_Builder)defaults).getName())) {
            this.setName(value.getName());
        }
        if (defaults._unsetProperties.contains((Object)Property.PLAN_TYPE) || !Objects.equals((Object)value.getPlanType(), (Object)((OrgModel_Builder)defaults).getPlanType())) {
            this.setPlanType(value.getPlanType());
        }
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder mergeFrom(OrgModel.Builder template) {
        OrgModel.Builder base = template;
        OrgModel.Builder defaults = new OrgModel.Builder();
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((OrgModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        if (!Objects.equals((Object)template.getType(), (Object)((OrgModel_Builder)defaults).getType())) {
            this.setType(template.getType());
        }
        if (!(base._unsetProperties.contains((Object)Property.NAME) || !defaults._unsetProperties.contains((Object)Property.NAME) && Objects.equals(template.getName(), ((OrgModel_Builder)defaults).getName()))) {
            this.setName(template.getName());
        }
        if (!(base._unsetProperties.contains((Object)Property.PLAN_TYPE) || !defaults._unsetProperties.contains((Object)Property.PLAN_TYPE) && Objects.equals((Object)template.getPlanType(), (Object)((OrgModel_Builder)defaults).getPlanType()))) {
            this.setPlanType(template.getPlanType());
        }
        return (OrgModel.Builder)this;
    }

    public OrgModel.Builder clear() {
        OrgModel.Builder defaults = new OrgModel.Builder();
        this.id = defaults.id;
        this.type = defaults.type;
        this.name = defaults.name;
        this.planType = defaults.planType;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (OrgModel.Builder)this;
    }

    public OrgModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public OrgModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final long id;
        @Nullable
        private final OrgModel.Type type;
        private final String name;
        private final PlanType planType;
        private final EnumSet<Property> _unsetProperties;

        Partial(OrgModel_Builder builder) {
            this.id = builder.id;
            this.type = builder.type;
            this.name = builder.name;
            this.planType = builder.planType;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="type")
        @Nullable
        public OrgModel.Type getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            if (this._unsetProperties.contains((Object)Property.NAME)) {
                throw new UnsupportedOperationException("name not set");
            }
            return this.name;
        }

        @Override
        @JsonProperty(value="planType")
        public PlanType getPlanType() {
            if (this._unsetProperties.contains((Object)Property.PLAN_TYPE)) {
                throw new UnsupportedOperationException("planType not set");
            }
            return this.planType;
        }

        @Override
        public OrgModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((OrgModel_Builder)builder).id = this.id;
            ((OrgModel_Builder)builder).type = this.type;
            ((OrgModel_Builder)builder).name = this.name;
            ((OrgModel_Builder)builder).planType = this.planType;
            ((OrgModel_Builder)builder)._unsetProperties.clear();
            ((OrgModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.id == other.id && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.planType, (Object)other.planType) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.type, this.name, this.planType, this._unsetProperties});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial OrgModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append("id=").append(this.id);
                separator = ", ";
            }
            if (this.type != null) {
                result.append(separator).append("type=").append((Object)this.type);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.NAME)) {
                result.append(separator).append("name=").append(this.name);
                separator = ", ";
            }
            if (!this._unsetProperties.contains((Object)Property.PLAN_TYPE)) {
                result.append(separator).append("planType=").append((Object)this.planType);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends OrgModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public OrgModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final long id;
        @Nullable
        private final OrgModel.Type type;
        private final String name;
        private final PlanType planType;

        private Value(OrgModel_Builder builder) {
            this.id = builder.id;
            this.type = builder.type;
            this.name = builder.name;
            this.planType = builder.planType;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="type")
        @Nullable
        public OrgModel.Type getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @JsonProperty(value="planType")
        public PlanType getPlanType() {
            return this.planType;
        }

        @Override
        public OrgModel.Builder toBuilder() {
            OrgModel.Builder builder = new OrgModel.Builder();
            ((OrgModel_Builder)builder).id = this.id;
            ((OrgModel_Builder)builder).type = this.type;
            ((OrgModel_Builder)builder).name = this.name;
            ((OrgModel_Builder)builder).planType = this.planType;
            ((OrgModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.id == other.id && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.planType, (Object)other.planType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.type, this.name, this.planType});
        }

        public String toString() {
            StringBuilder result = new StringBuilder("OrgModel{id=").append(this.id);
            if (this.type != null) {
                result.append(", type=").append((Object)this.type);
            }
            return result.append(", name=").append(this.name).append(", planType=").append((Object)this.planType).append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements OrgModel {
        private Rebuildable() {
        }

        public abstract OrgModel.Builder toBuilder();
    }

    private static enum Property {
        ID("id"),
        NAME("name"),
        PLAN_TYPE("planType");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

