/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.latte.genids;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.analysis.latte.genids.ExportStatus;
import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.analysis.latte.genids.IdComponent;
import com.sourceclear.analysis.latte.genids.IdListener;
import com.sourceclear.analysis.latte.genids.ScopeListener;
import com.sourceclear.analysis.latte.genids.SimpleIdListener;
import com.sourceclear.analysis.latte.genids.SimpleScopeListener;
import com.sourceclear.analysis.latte.genids.VisitorUtils;
import com.sourceclear.analysis.latte.parser.JavaScriptParser;
import com.sourceclear.analysis.latte.parser.JavaScriptParserBaseVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\"H\u0004J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020$0\u00162\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010/\u001a\u0004\u0018\u00010\u0012J\u0010\u00100\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u00101\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0019H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u000204H\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u000206H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u000208H\u0016J\u0012\u00109\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020:H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020<H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020>H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020@H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020BH\u0016J\u0012\u0010C\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020DH\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020FH\u0016J\u0012\u0010G\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020HH\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020JH\u0016J\u0012\u0010K\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020LH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020NH\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/sourceclear/analysis/latte/genids/ScopeVisitor;", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParserBaseVisitor;", "Ljava/lang/Void;", "filename", "", "scopeListener", "Lcom/sourceclear/analysis/latte/genids/ScopeListener;", "idListener", "Lcom/sourceclear/analysis/latte/genids/IdListener;", "(Ljava/lang/String;Lcom/sourceclear/analysis/latte/genids/ScopeListener;Lcom/sourceclear/analysis/latte/genids/IdListener;)V", "counts", "", "", "exportStatus", "Lcom/sourceclear/analysis/latte/genids/ExportStatus;", "getFilename", "()Ljava/lang/String;", "global", "Lcom/sourceclear/analysis/latte/genids/Id;", "getGlobal", "()Lcom/sourceclear/analysis/latte/genids/Id;", "nodeExportsKeywords", "", "scopeStack", "Ljava/util/ArrayDeque;", "Lcom/sourceclear/analysis/latte/genids/IdComponent;", "currentId", "freshCount", "genId", "id", "handleAnonymousFunction", "ctx", "Lorg/antlr/v4/runtime/ParserRuleContext;", "parentVisitorMethod", "Lkotlin/Function0;", "handleArrayDestructuring", "Lcom/sourceclear/analysis/latte/genids/IdComponent$Identifier;", "arrayLiteral", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ArrayLiteralContext;", "handleObjectDestructuring", "objectLiteral", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ObjectLiteralContext;", "mergeId", "input", "notifyIdOnly", "", "idComponent", "parentScope", "popScope", "pushScope", "renameExportedId", "visitAliasName", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$AliasNameContext;", "visitAnoymousFunctionDecl", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$AnoymousFunctionDeclContext;", "visitArrowFunction", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ArrowFunctionContext;", "visitAssignmentExpression", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$AssignmentExpressionContext;", "visitClassDeclaration", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ClassDeclarationContext;", "visitExportDeclaration", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ExportDeclarationContext;", "visitExportDefaultDeclaration", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ExportDefaultDeclarationContext;", "visitFunctionDeclaration", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$FunctionDeclarationContext;", "visitFunctionProperty", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$FunctionPropertyContext;", "visitMethodDefinition", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$MethodDefinitionContext;", "visitPropertyExpressionAssignment", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$PropertyExpressionAssignmentContext;", "visitPropertyGetter", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$PropertyGetterContext;", "visitPropertySetter", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$PropertySetterContext;", "visitVariableDeclaration", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$VariableDeclarationContext;", "vulnerable-methods"})
public class ScopeVisitor
extends JavaScriptParserBaseVisitor<Void> {
    @NotNull
    private final String filename;
    @NotNull
    private final ScopeListener scopeListener;
    @NotNull
    private final IdListener idListener;
    @NotNull
    private final ArrayDeque<IdComponent> scopeStack;
    @NotNull
    private final Map<String, Integer> counts;
    @NotNull
    private ExportStatus exportStatus;
    @NotNull
    private final List<String> nodeExportsKeywords;
    @NotNull
    private final Id global;

    public ScopeVisitor(@NotNull String filename, @NotNull ScopeListener scopeListener, @NotNull IdListener idListener) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)scopeListener, (String)"scopeListener");
        Intrinsics.checkNotNullParameter((Object)idListener, (String)"idListener");
        this.filename = filename;
        this.scopeListener = scopeListener;
        this.idListener = idListener;
        this.scopeStack = new ArrayDeque();
        this.counts = new LinkedHashMap();
        this.exportStatus = ExportStatus.NonExport;
        Object[] objectArray = new String[]{"module.exports.", "exports."};
        this.nodeExportsKeywords = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"global"};
        this.global = new Id(this.getFilename(), CollectionsKt.listOf((Object)new IdComponent.Identifier((String[])objectArray)));
    }

    public /* synthetic */ ScopeVisitor(String string, ScopeListener scopeListener, IdListener idListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scopeListener = new SimpleScopeListener();
        }
        if ((n & 4) != 0) {
            idListener = new SimpleIdListener();
        }
        this(string, scopeListener, idListener);
    }

    @NotNull
    public String getFilename() {
        return this.filename;
    }

    @NotNull
    protected final Id getGlobal() {
        return this.global;
    }

    @Override
    @Nullable
    public Void visitAliasName(@NotNull JavaScriptParser.AliasNameContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        if (this.exportStatus == ExportStatus.Export) {
            String identifier = ctx.identifierName().size() == 2 ? ctx.identifierName(1).getText() : ctx.identifierName(0).getText();
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
            stringArray[0] = identifier;
            this.pushScope(new IdComponent.Identifier(stringArray), ctx);
        }
        super.visitAliasName(ctx);
        if (this.exportStatus == ExportStatus.Export) {
            this.popScope(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitExportDeclaration(@NotNull JavaScriptParser.ExportDeclarationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.exportStatus = ExportStatus.Export;
        super.visitExportDeclaration(ctx);
        this.exportStatus = ExportStatus.NonExport;
        return null;
    }

    @Override
    @Nullable
    public Void visitExportDefaultDeclaration(@NotNull JavaScriptParser.ExportDefaultDeclarationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        this.exportStatus = ExportStatus.DefaultExport;
        super.visitExportDefaultDeclaration(ctx);
        this.exportStatus = ExportStatus.NonExport;
        return null;
    }

    @Override
    @Nullable
    public Void visitClassDeclaration(@NotNull JavaScriptParser.ClassDeclarationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String identifier = ctx.identifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
        this.pushScope(new IdComponent.Class(identifier), ctx);
        super.visitClassDeclaration(ctx);
        this.popScope(ctx);
        return null;
    }

    @Override
    @Nullable
    public Void visitMethodDefinition(@NotNull JavaScriptParser.MethodDefinitionContext ctx) {
        String it;
        String identifier;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        JavaScriptParser.PropertyNameContext propertyNameContext = ctx.propertyName();
        String string = propertyNameContext == null ? null : propertyNameContext.getText();
        if (string == null) {
            String it2;
            String string2;
            JavaScriptParser.GetterContext getterContext = ctx.getter();
            if (getterContext == null) {
                string2 = null;
            } else {
                JavaScriptParser.PropertyNameContext propertyNameContext2 = getterContext.propertyName();
                if (propertyNameContext2 == null) {
                    string2 = null;
                } else {
                    String string3 = propertyNameContext2.getText();
                    if (string3 == null) {
                        string2 = null;
                    } else {
                        it2 = string3;
                        boolean bl = false;
                        string2 = Intrinsics.stringPlus((String)"__getter__", (Object)it2);
                    }
                }
            }
            String string4 = string2;
            if (string4 == null) {
                JavaScriptParser.SetterContext setterContext = ctx.setter();
                if (setterContext == null) {
                    string = null;
                } else {
                    JavaScriptParser.PropertyNameContext propertyNameContext3 = setterContext.propertyName();
                    if (propertyNameContext3 == null) {
                        string = null;
                    } else {
                        String string5 = propertyNameContext3.getText();
                        if (string5 == null) {
                            string = null;
                        } else {
                            it2 = string5;
                            boolean bl = false;
                            string = Intrinsics.stringPlus((String)"__setter__", (Object)it2);
                        }
                    }
                }
            } else {
                string = string4;
            }
        }
        String string6 = identifier = string;
        if (string6 != null) {
            it = string6;
            boolean bl = false;
            String[] stringArray = new String[]{it};
            this.pushScope(new IdComponent.Function(stringArray), ctx);
        }
        super.visitMethodDefinition(ctx);
        String string7 = identifier;
        if (string7 != null) {
            it = string7;
            boolean bl = false;
            this.popScope(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitAnoymousFunctionDecl(@NotNull JavaScriptParser.AnoymousFunctionDeclContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        return this.handleAnonymousFunction(ctx, (Function0<Void>)((Function0)new Function0<Void>(this, ctx){
            final /* synthetic */ ScopeVisitor this$0;
            final /* synthetic */ JavaScriptParser.AnoymousFunctionDeclContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            @Nullable
            public final Void invoke() {
                return (Void)ScopeVisitor.access$visitAnoymousFunctionDecl$s611920017(this.this$0, this.$ctx);
            }
        }));
    }

    @Override
    @Nullable
    public Void visitArrowFunction(@NotNull JavaScriptParser.ArrowFunctionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        return this.handleAnonymousFunction(ctx, (Function0<Void>)((Function0)new Function0<Void>(this, ctx){
            final /* synthetic */ ScopeVisitor this$0;
            final /* synthetic */ JavaScriptParser.ArrowFunctionContext $ctx;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(0);
            }

            @Nullable
            public final Void invoke() {
                return (Void)ScopeVisitor.access$visitArrowFunction$s611920017(this.this$0, this.$ctx);
            }
        }));
    }

    @Override
    @Nullable
    public Void visitFunctionDeclaration(@NotNull JavaScriptParser.FunctionDeclarationContext ctx) {
        RuleContext ruleContext;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        RuleContext ruleContext2 = ctx.parent;
        if (ruleContext2 == null) {
            object = null;
        } else {
            RuleContext ruleContext3 = ruleContext2.parent;
            object = ruleContext = ruleContext3 == null ? null : ruleContext3.parent;
        }
        if ((ruleContext instanceof JavaScriptParser.AssignmentExpressionContext ? true : ruleContext instanceof JavaScriptParser.VariableDeclarationContext) ? true : ruleContext instanceof JavaScriptParser.PropertyExpressionAssignmentContext) {
            return (Void)super.visitFunctionDeclaration(ctx);
        }
        String identifier = ctx.identifier().getText();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
        stringArray[0] = identifier;
        this.pushScope(new IdComponent.Function(stringArray), ctx);
        super.visitFunctionDeclaration(ctx);
        this.popScope(ctx);
        return null;
    }

    @Override
    @Nullable
    public Void visitVariableDeclaration(@NotNull JavaScriptParser.VariableDeclarationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        boolean entered = false;
        JavaScriptParser.AssignableContext assignable = ctx.assignable();
        JavaScriptParser.ArrayLiteralContext arrayLiteralContext = assignable.arrayLiteral();
        if (arrayLiteralContext != null) {
            JavaScriptParser.ArrayLiteralContext it = arrayLiteralContext;
            boolean bl = false;
            List<IdComponent.Identifier> ids = this.handleArrayDestructuring(it);
            Iterable $this$forEach$iv = ids;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdComponent.Identifier id = (IdComponent.Identifier)element$iv;
                boolean bl2 = false;
                this.notifyIdOnly(id, ctx);
            }
            return null;
        }
        JavaScriptParser.ObjectLiteralContext objectLiteralContext = assignable.objectLiteral();
        if (objectLiteralContext != null) {
            JavaScriptParser.ObjectLiteralContext it = objectLiteralContext;
            boolean bl = false;
            List<IdComponent.Identifier> ids = this.handleObjectDestructuring(it);
            Iterable $this$forEach$iv = ids;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IdComponent.Identifier id = (IdComponent.Identifier)element$iv;
                boolean bl3 = false;
                this.notifyIdOnly(id, ctx);
            }
            return null;
        }
        JavaScriptParser.IdentifierContext identifierContext = assignable.identifier();
        if (identifierContext != null) {
            JavaScriptParser.IdentifierContext it = identifierContext;
            boolean bl = false;
            JavaScriptParser.SingleExpressionContext singleExpressionContext = ctx.singleExpression();
            if (singleExpressionContext instanceof JavaScriptParser.FunctionExpressionContext) {
                entered = true;
                String[] stringArray = new String[1];
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                stringArray[0] = string;
                this.pushScope(new IdComponent.Function(stringArray), ctx);
            } else if (singleExpressionContext instanceof JavaScriptParser.ObjectLiteralExpressionContext) {
                entered = true;
                String[] stringArray = new String[1];
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                stringArray[0] = string;
                this.pushScope(new IdComponent.Identifier(stringArray), ctx);
            } else {
                String[] stringArray = new String[1];
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                stringArray[0] = string;
                this.notifyIdOnly(new IdComponent.Identifier(stringArray), ctx);
            }
        }
        super.visitVariableDeclaration(ctx);
        if (entered) {
            this.popScope(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitAssignmentExpression(@NotNull JavaScriptParser.AssignmentExpressionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        boolean entered = false;
        JavaScriptParser.SingleExpressionContext singleExpressionContext = ctx.singleExpression(0);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)singleExpressionContext), (String)"ctx.singleExpression(0)");
        List<String> names = VisitorUtils.INSTANCE.unrollSingleExpressionToNames(singleExpressionContext);
        singleExpressionContext = ctx.singleExpression(1);
        if (singleExpressionContext instanceof JavaScriptParser.ObjectLiteralExpressionContext) {
            this.pushScope(new IdComponent.Identifier(names), ctx);
            entered = true;
        } else if (singleExpressionContext instanceof JavaScriptParser.FunctionExpressionContext) {
            this.pushScope(new IdComponent.Function(names), ctx);
            entered = true;
        } else {
            IdComponent.Identifier component = new IdComponent.Identifier(names);
            this.notifyIdOnly(component, ctx);
        }
        super.visitAssignmentExpression(ctx);
        if (entered) {
            this.popScope(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitPropertyExpressionAssignment(@NotNull JavaScriptParser.PropertyExpressionAssignmentContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String identifier = ctx.propertyName().getText();
        if (ctx.singleExpression() instanceof JavaScriptParser.FunctionExpressionContext) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
            stringArray[0] = identifier;
            this.pushScope(new IdComponent.Function(stringArray), ctx);
        } else {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
            stringArray[0] = identifier;
            this.pushScope(new IdComponent.Identifier(stringArray), ctx);
        }
        super.visitPropertyExpressionAssignment(ctx);
        this.popScope(ctx);
        return null;
    }

    @Override
    @Nullable
    public Void visitFunctionProperty(@NotNull JavaScriptParser.FunctionPropertyContext ctx) {
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        String identifier = ctx.propertyName().getText();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"identifier");
        stringArray[0] = identifier;
        this.pushScope(new IdComponent.Function(stringArray), ctx);
        super.visitFunctionProperty(ctx);
        this.popScope(ctx);
        return null;
    }

    @Override
    @Nullable
    public Void visitPropertySetter(@NotNull JavaScriptParser.PropertySetterContext ctx) {
        String text;
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        JavaScriptParser.SetterContext setterContext = ctx.setter();
        if (setterContext == null) {
            string = null;
        } else {
            JavaScriptParser.PropertyNameContext propertyNameContext = setterContext.propertyName();
            string = text = propertyNameContext == null ? null : propertyNameContext.getText();
        }
        if (text != null) {
            String[] stringArray = new String[]{Intrinsics.stringPlus((String)"__setter__", (Object)text)};
            this.pushScope(new IdComponent.Function(stringArray), ctx);
            super.visitPropertySetter(ctx);
            this.popScope(ctx);
        } else {
            super.visitPropertySetter(ctx);
        }
        return null;
    }

    @Override
    @Nullable
    public Void visitPropertyGetter(@NotNull JavaScriptParser.PropertyGetterContext ctx) {
        String text;
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)ctx), (String)"ctx");
        JavaScriptParser.GetterContext getterContext = ctx.getter();
        if (getterContext == null) {
            string = null;
        } else {
            JavaScriptParser.PropertyNameContext propertyNameContext = getterContext.propertyName();
            string = text = propertyNameContext == null ? null : propertyNameContext.getText();
        }
        if (text != null) {
            String[] stringArray = new String[]{Intrinsics.stringPlus((String)"__getter__", (Object)text)};
            this.pushScope(new IdComponent.Function(stringArray), ctx);
            super.visitPropertyGetter(ctx);
            this.popScope(ctx);
        } else {
            super.visitPropertyGetter(ctx);
        }
        return null;
    }

    private final List<IdComponent.Identifier> handleArrayDestructuring(JavaScriptParser.ArrayLiteralContext arrayLiteral) {
        List result = new ArrayList();
        List<JavaScriptParser.ArrayElementContext> list = arrayLiteral.elementList().arrayElement();
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JavaScriptParser.SingleExpressionContext propertyName;
                String[] stringArray;
                String[] stringArray2;
                JavaScriptParser.ArrayElementContext it = (JavaScriptParser.ArrayElementContext)((Object)element$iv);
                boolean bl = false;
                JavaScriptParser.SingleExpressionContext singleExpr = it.singleExpression();
                if (singleExpr instanceof JavaScriptParser.IdentifierExpressionContext) {
                    stringArray2 = new String[1];
                    stringArray = ((JavaScriptParser.IdentifierExpressionContext)singleExpr).identifier().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"singleExpr.identifier().text");
                    stringArray2[0] = stringArray;
                    result.add(new IdComponent.Identifier(stringArray2));
                    continue;
                }
                if (singleExpr instanceof JavaScriptParser.ObjectLiteralExpressionContext) {
                    stringArray2 = ((JavaScriptParser.ObjectLiteralExpressionContext)singleExpr).objectLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"singleExpr.objectLiteral()");
                    result.addAll((Collection)this.handleObjectDestructuring((JavaScriptParser.ObjectLiteralContext)stringArray2));
                    continue;
                }
                if (singleExpr instanceof JavaScriptParser.ArrayLiteralExpressionContext) {
                    stringArray2 = ((JavaScriptParser.ArrayLiteralExpressionContext)singleExpr).arrayLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"singleExpr.arrayLiteral()");
                    result.addAll((Collection)this.handleArrayDestructuring((JavaScriptParser.ArrayLiteralContext)stringArray2));
                    continue;
                }
                if (!(singleExpr instanceof JavaScriptParser.AssignmentExpressionContext) || !((propertyName = ((JavaScriptParser.AssignmentExpressionContext)singleExpr).singleExpression(0)) instanceof JavaScriptParser.IdentifierExpressionContext)) continue;
                stringArray = new String[1];
                String string = ((JavaScriptParser.IdentifierExpressionContext)propertyName).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertyName.text");
                stringArray[0] = string;
                result.add(new IdComponent.Identifier(stringArray));
            }
        }
        return CollectionsKt.toList((Iterable)result);
    }

    private final List<IdComponent.Identifier> handleObjectDestructuring(JavaScriptParser.ObjectLiteralContext objectLiteral) {
        List result = new ArrayList();
        List<JavaScriptParser.PropertyAssignmentContext> list = objectLiteral.propertyAssignment();
        Intrinsics.checkNotNullExpressionValue(list, (String)"objectLiteral.propertyAssignment()");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JavaScriptParser.SingleExpressionContext rhs;
            JavaScriptParser.PropertyAssignmentContext it = (JavaScriptParser.PropertyAssignmentContext)((Object)element$iv);
            boolean bl = false;
            JavaScriptParser.PropertyAssignmentContext propertyAssignmentContext = it;
            if (propertyAssignmentContext instanceof JavaScriptParser.PropertyExpressionAssignmentContext) {
                JavaScriptParser.SingleExpressionContext renamed;
                ParserRuleContext parserRuleContext;
                rhs = ((JavaScriptParser.PropertyExpressionAssignmentContext)it).singleExpression();
                if (rhs instanceof JavaScriptParser.ArrayLiteralExpressionContext) {
                    parserRuleContext = ((JavaScriptParser.ArrayLiteralExpressionContext)rhs).arrayLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)parserRuleContext, (String)"rhs.arrayLiteral()");
                    result.addAll((Collection)this.handleArrayDestructuring((JavaScriptParser.ArrayLiteralContext)parserRuleContext));
                    continue;
                }
                if (rhs instanceof JavaScriptParser.ObjectLiteralExpressionContext) {
                    parserRuleContext = ((JavaScriptParser.ObjectLiteralExpressionContext)rhs).objectLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)parserRuleContext, (String)"rhs.objectLiteral()");
                    result.addAll((Collection)this.handleObjectDestructuring((JavaScriptParser.ObjectLiteralContext)parserRuleContext));
                    continue;
                }
                if (rhs instanceof JavaScriptParser.IdentifierExpressionContext) {
                    result.add(new IdComponent.Identifier(CollectionsKt.listOf((Object)((JavaScriptParser.IdentifierExpressionContext)rhs).identifier().getText())));
                    continue;
                }
                if (!(rhs instanceof JavaScriptParser.AssignmentExpressionContext) || !((renamed = ((JavaScriptParser.AssignmentExpressionContext)rhs).singleExpression(0)) instanceof JavaScriptParser.IdentifierExpressionContext)) continue;
                result.add(new IdComponent.Identifier(CollectionsKt.listOf((Object)((JavaScriptParser.IdentifierExpressionContext)renamed).identifier().getText())));
                continue;
            }
            if (!(propertyAssignmentContext instanceof JavaScriptParser.PropertyShorthandContext)) continue;
            rhs = ((JavaScriptParser.PropertyShorthandContext)it).singleExpression();
            if (rhs instanceof JavaScriptParser.AssignmentExpressionContext) {
                JavaScriptParser.SingleExpressionContext propertyName = ((JavaScriptParser.AssignmentExpressionContext)rhs).singleExpression(0);
                if (!(propertyName instanceof JavaScriptParser.IdentifierExpressionContext)) continue;
                result.add(new IdComponent.Identifier(CollectionsKt.listOf((Object)((JavaScriptParser.IdentifierExpressionContext)propertyName).identifier().getText())));
                continue;
            }
            if (!(rhs instanceof JavaScriptParser.IdentifierExpressionContext)) continue;
            result.add(new IdComponent.Identifier(CollectionsKt.listOf((Object)((JavaScriptParser.IdentifierExpressionContext)rhs).identifier().getText())));
        }
        return CollectionsKt.toList((Iterable)result);
    }

    @Nullable
    protected final Void handleAnonymousFunction(@NotNull ParserRuleContext ctx, @NotNull Function0<Void> parentVisitorMethod) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(parentVisitorMethod, (String)"parentVisitorMethod");
        RuleContext ruleContext = ctx.parent;
        RuleContext ruleContext2 = ruleContext == null ? null : ruleContext.parent;
        if ((ruleContext2 instanceof JavaScriptParser.VariableDeclarationContext ? true : ruleContext2 instanceof JavaScriptParser.AssignmentExpressionContext) ? true : ruleContext2 instanceof JavaScriptParser.PropertyExpressionAssignmentContext) {
            parentVisitorMethod.invoke();
            return null;
        }
        this.pushScope(new IdComponent.AnonymousFunction(this.freshCount()), ctx);
        parentVisitorMethod.invoke();
        this.popScope(ctx);
        return null;
    }

    private final int freshCount() {
        String parentId = new Id(this.getFilename(), CollectionsKt.reversed((Iterable)this.scopeStack)).toString();
        int count = ((Number)this.counts.getOrDefault(parentId, 0)).intValue();
        Map<String, Integer> map = this.counts;
        Integer n = count + 1;
        map.put(parentId, n);
        return count;
    }

    private final Id genId(IdComponent id) {
        List input = CollectionsKt.plus((Collection)CollectionsKt.reversed((Iterable)this.scopeStack), (Object)id);
        return new Id(this.getFilename(), this.mergeId(input));
    }

    private final void pushScope(IdComponent idComponent, ParserRuleContext ctx) {
        IdComponent transferredId = this.renameExportedId(idComponent);
        Id id = this.genId(transferredId);
        this.scopeStack.push(transferredId);
        this.scopeListener.onScopeEnter(id, ctx);
        this.idListener.onId(id, this.currentId(), this.parentScope(), ctx);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IdComponent renameExportedId(IdComponent idComponent) {
        IdComponent idComponent2;
        if (this.scopeStack.isEmpty()) {
            Object v1;
            block19: {
                switch (WhenMappings.$EnumSwitchMapping$0[this.exportStatus.ordinal()]) {
                    case 1: {
                        Object[] objectArray = new String[]{"module", "exports"};
                        List prefix = CollectionsKt.listOf((Object[])objectArray);
                        IdComponent idComponent3 = idComponent;
                        if (idComponent3 instanceof IdComponent.Class) {
                            idComponent2 = new IdComponent.Identifier(CollectionsKt.plus((Collection)prefix, (Object)((IdComponent.Class)idComponent).getName()));
                            return idComponent2;
                        }
                        if (idComponent3 instanceof IdComponent.Function) {
                            idComponent2 = new IdComponent.Identifier(CollectionsKt.plus((Collection)prefix, (Iterable)((IdComponent.Function)idComponent).getNames()));
                            return idComponent2;
                        }
                        if (idComponent3 instanceof IdComponent.Identifier) {
                            idComponent2 = new IdComponent.Identifier(CollectionsKt.plus((Collection)prefix, (Iterable)((IdComponent.Identifier)idComponent).getNames()));
                            return idComponent2;
                        }
                        idComponent2 = idComponent;
                        return idComponent2;
                    }
                    case 2: {
                        String[] prefix = new String[]{"module", "exports", "default"};
                        idComponent2 = new IdComponent.Identifier(prefix);
                        return idComponent2;
                    }
                }
                Iterable iterable = this.nodeExportsKeywords;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : iterable) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)idComponent.toString(), (String)it, (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block19;
                }
                v1 = null;
            }
            String matched = v1;
            if (matched == null) {
                idComponent2 = idComponent;
                return idComponent2;
            }
            IdComponent idComponent4 = idComponent;
            if (idComponent4 instanceof IdComponent.Class) {
                String[] stringArray = new String[]{"module", "exports", ((IdComponent.Class)idComponent).getName()};
                idComponent2 = new IdComponent.Identifier(stringArray);
                return idComponent2;
            }
            if (idComponent4 instanceof IdComponent.Function) {
                idComponent2 = Intrinsics.areEqual((Object)((IdComponent.Function)idComponent).getNames().get(0), (Object)"exports") ? new IdComponent.Identifier(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"module"), (Iterable)((IdComponent.Function)idComponent).getNames())) : new IdComponent.Identifier(((IdComponent.Function)idComponent).getNames());
                return idComponent2;
            }
            if (!(idComponent4 instanceof IdComponent.Identifier)) {
                idComponent2 = idComponent;
                return idComponent2;
            }
            idComponent2 = Intrinsics.areEqual((Object)((IdComponent.Identifier)idComponent).getNames().get(0), (Object)"exports") ? new IdComponent.Identifier(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"module"), (Iterable)((IdComponent.Identifier)idComponent).getNames())) : (IdComponent.Identifier)idComponent;
            return idComponent2;
        }
        if (Intrinsics.areEqual((Object)this.scopeStack.getFirst().toString(), (Object)"exports")) {
            Object[] objectArray = new String[]{"module", "exports"};
            List prefix = CollectionsKt.listOf((Object[])objectArray);
            IdComponent idComponent5 = idComponent;
            if (idComponent5 instanceof IdComponent.Class) {
                idComponent2 = new IdComponent.Identifier(CollectionsKt.plus((Collection)prefix, (Object)StringsKt.drop((String)((IdComponent.Class)idComponent).getName(), (int)"exports.".length())));
                return idComponent2;
            }
            if (idComponent5 instanceof IdComponent.Function) {
                idComponent2 = new IdComponent.Identifier(CollectionsKt.plus((Collection)prefix, (Iterable)CollectionsKt.drop((Iterable)((IdComponent.Function)idComponent).getNames(), (int)1)));
                return idComponent2;
            }
            idComponent2 = idComponent;
            return idComponent2;
        }
        if (!StringsKt.startsWith$default((String)this.scopeStack.getFirst().toString(), (String)"module.exports", (boolean)false, (int)2, null)) {
            idComponent2 = idComponent;
            return idComponent2;
        }
        IdComponent idComponent6 = idComponent;
        if (idComponent6 instanceof IdComponent.Class) {
            String[] stringArray = new String[]{"module", "exports", StringsKt.drop((String)((IdComponent.Class)idComponent).getName(), (int)"module.exports.".length())};
            idComponent2 = new IdComponent.Identifier(stringArray);
            return idComponent2;
        }
        if (idComponent6 instanceof IdComponent.Function) {
            idComponent2 = new IdComponent.Identifier(((IdComponent.Function)idComponent).getNames());
            return idComponent2;
        }
        idComponent2 = idComponent;
        return idComponent2;
    }

    private final void popScope(ParserRuleContext ctx) {
        this.scopeStack.pop();
        this.scopeListener.onScopeLeave(ctx);
    }

    private final void notifyIdOnly(IdComponent idComponent, ParserRuleContext ctx) {
        this.idListener.onId(this.genId(idComponent), this.currentId(), this.parentScope(), ctx);
    }

    @VisibleForTesting
    @NotNull
    public final List<IdComponent> mergeId(@NotNull List<? extends IdComponent> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List result = new ArrayList();
        int index = 0;
        while (index < input.size()) {
            if (input.get(index) instanceof IdComponent.Identifier) {
                if (index == input.size() - 1) {
                    result.add(input.get(index));
                    break;
                }
                int nextIndex = ScopeVisitor.mergeId$nextNonidentifierIndex(input, index + 1);
                List names = new ArrayList();
                int n = index;
                while (n < nextIndex) {
                    int i;
                    IdComponent next;
                    if (!((next = input.get(i = n++)) instanceof IdComponent.Identifier)) continue;
                    names.addAll((Collection)((IdComponent.Identifier)next).getNames());
                }
                IdComponent nextId = input.get(nextIndex);
                if (nextId instanceof IdComponent.Identifier) {
                    result.add(new IdComponent.Identifier(CollectionsKt.plus((Collection)names, (Iterable)((IdComponent.Identifier)nextId).getNames())));
                } else if (nextId instanceof IdComponent.Function) {
                    result.add(new IdComponent.Function(CollectionsKt.plus((Collection)names, (Iterable)((IdComponent.Function)nextId).getNames())));
                } else if (nextId instanceof IdComponent.Class) {
                    result.add(new IdComponent.Class(CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)names, (Object)((IdComponent.Class)nextId).getName()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null)));
                } else if (nextId instanceof IdComponent.AnonymousFunction) {
                    result.add(input.get(index));
                    result.add(new IdComponent.AnonymousFunction(((IdComponent.AnonymousFunction)nextId).getId()));
                }
                index = nextIndex + 1;
                continue;
            }
            result.add(input.get(index));
            ++index;
        }
        return result;
    }

    @NotNull
    public final Id currentId() {
        return this.scopeStack.isEmpty() ? this.global : new Id(this.getFilename(), this.mergeId(CollectionsKt.reversed((Iterable)this.scopeStack)));
    }

    @Nullable
    public final Id parentScope() {
        return this.scopeStack.isEmpty() ? null : (this.scopeStack.size() == 1 ? this.global : new Id(this.getFilename(), this.mergeId(CollectionsKt.dropLast((List)CollectionsKt.reversed((Iterable)this.scopeStack), (int)1))));
    }

    private static final int mergeId$nextNonidentifierIndex(List<? extends IdComponent> $input, int index) {
        int end;
        for (end = index; end < $input.size() - 1; ++end) {
            if ($input.get(end) instanceof IdComponent.Identifier) {
                continue;
            }
            return end;
        }
        return end;
    }

    public static final /* synthetic */ Object access$visitAnoymousFunctionDecl$s611920017(ScopeVisitor $this, JavaScriptParser.AnoymousFunctionDeclContext ctx) {
        return super.visitAnoymousFunctionDecl(ctx);
    }

    public static final /* synthetic */ Object access$visitArrowFunction$s611920017(ScopeVisitor $this, JavaScriptParser.ArrowFunctionContext ctx) {
        return super.visitArrowFunction(ctx);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExportStatus.values().length];
            nArray[ExportStatus.Export.ordinal()] = 1;
            nArray[ExportStatus.DefaultExport.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

