/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.lexer;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.util.ByteList;
import org.jrubyparser.RubyEncoding;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.lexer.yacc.SimpleSourcePosition;
import org.jrubyparser.lexer.yacc.StackState;

public abstract class LexingCommon {
    public static final int EXPR_BEG = 1;
    public static final int EXPR_END = 2;
    public static final int EXPR_ENDARG = 4;
    public static final int EXPR_ENDFN = 8;
    public static final int EXPR_ARG = 16;
    public static final int EXPR_CMDARG = 32;
    public static final int EXPR_MID = 64;
    public static final int EXPR_FNAME = 128;
    public static final int EXPR_DOT = 256;
    public static final int EXPR_CLASS = 512;
    public static final int EXPR_LABEL = 1024;
    public static final int EXPR_LABELED = 2048;
    public static final int EXPR_VALUE = 1;
    public static final int EXPR_BEG_ANY = 577;
    public static final int EXPR_ARG_ANY = 48;
    public static final int EXPR_END_ANY = 14;
    protected int braceNest = 0;
    public boolean commandStart;
    protected StackState conditionState = new StackState();
    protected StackState cmdArgumentState = new StackState();
    private String current_arg;
    private Encoding current_enc;
    protected boolean __end__seen = false;
    public boolean eofp = false;
    protected boolean has_shebang = false;
    protected int heredoc_end = 0;
    protected int heredoc_indent = 0;
    protected int heredoc_line_indent = 0;
    public boolean inKwarg = false;
    protected int last_cr_line;
    protected int last_state;
    private int leftParenBegin = 0;
    public ByteList lexb = null;
    public ByteList lex_lastline = null;
    protected ByteList lex_nextline = null;
    public int lex_p = 0;
    protected int lex_pbeg = 0;
    public int lex_pend = 0;
    protected int lex_state;
    protected int line_count = 0;
    protected int line_offset = 0;
    protected int parenNest = 0;
    protected int ruby_sourceline = 0;
    protected LexerSource src;
    protected int token;
    private int tokenCR;
    protected boolean tokenSeen = false;
    public ISourcePosition tokline;
    public int tokp = 0;
    protected Object yaccValue;
    public static final int TAB_WIDTH = 8;
    public static final int STR_FUNC_ESCAPE = 1;
    public static final int STR_FUNC_EXPAND = 2;
    public static final int STR_FUNC_REGEXP = 4;
    public static final int STR_FUNC_QWORDS = 8;
    public static final int STR_FUNC_SYMBOL = 16;
    public static final int STR_FUNC_INDENT = 32;
    public static final int STR_FUNC_LABEL = 64;
    public static final int str_label = 64;
    public static final int str_squote = 0;
    public static final int str_dquote = 2;
    public static final int str_xquote = 2;
    public static final int str_regexp = 7;
    public static final int str_ssym = 16;
    public static final int str_dsym = 18;
    public static final int EOF = -1;
    public static ByteList END_MARKER = new ByteList(new byte[]{95, 95, 69, 78, 68, 95, 95});
    public static ByteList BEGIN_DOC_MARKER = new ByteList(new byte[]{98, 101, 103, 105, 110});
    public static ByteList END_DOC_MARKER = new ByteList(new byte[]{101, 110, 100});
    public static ByteList CODING = new ByteList(new byte[]{99, 111, 100, 105, 110, 103});
    public static final Encoding UTF8_ENCODING = UTF8Encoding.INSTANCE;
    public static final Encoding USASCII_ENCODING = USASCIIEncoding.INSTANCE;
    public static final Encoding ASCII8BIT_ENCODING = ASCIIEncoding.INSTANCE;
    public static final int SUFFIX_R = 1;
    public static final int SUFFIX_I = 2;
    public static final int SUFFIX_ALL = 3;
    public static final String magicString = "^[^\\S]*([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*[^\\S]*$";
    public static final Regex magicRegexp = new Regex("^[^\\S]*([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*[^\\S]*$".getBytes(), 0, "^[^\\S]*([^\\s'\":;]+)\\s*:\\s*(\"(?:\\\\.|[^\"])*\"|[^\"\\s;]+)[\\s;]*[^\\S]*$".length(), 0, Encoding.load((String)"ASCII"));

    public LexingCommon(LexerSource src) {
        this.src = src;
    }

    public int column() {
        return this.tokp - this.lex_pbeg;
    }

    protected boolean comment_at_top() {
        int pend = this.lex_p - 1;
        if (this.line_count != (this.has_shebang ? 2 : 1)) {
            return false;
        }
        for (int p = this.lex_pbeg; p < pend; ++p) {
            if (Character.isSpaceChar(this.p(p))) continue;
            return false;
        }
        return true;
    }

    public ByteList createTokenByteList() {
        return new ByteList(this.lexb.unsafeBytes(), this.lexb.begin() + this.tokp, this.lex_p - this.tokp, this.getEncoding(), false);
    }

    public String createTokenString(int start) {
        return this.createAsEncodedString(this.lexb.getUnsafeBytes(), this.lexb.begin() + start, this.lex_p - start, this.getEncoding());
    }

    public String createAsEncodedString(byte[] bytes, int start, int length, Encoding encoding) {
        try {
            Charset charset = this.getEncoding().getCharset();
            if (charset != null) {
                if (charset == RubyEncoding.UTF8) {
                    return RubyEncoding.decodeUTF8(bytes, start, length);
                }
                return new String(bytes, start, length, charset);
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return new String(bytes, start, length);
    }

    public String createTokenString() {
        return this.createTokenString(this.tokp);
    }

    protected int dedent_string(ByteList string, int width) {
        long len = string.realSize();
        int col = 0;
        byte[] str = string.unsafeBytes();
        int begin = string.begin();
        int i = 0;
        while ((long)i < len && col < width) {
            if (str[begin + i] == 32) {
                ++col;
            } else {
                int n;
                if (str[begin + i] != 9 || (n = 8 * (col / 8 + 1)) > width) break;
                col = n;
            }
            ++i;
        }
        string.setBegin(begin + i);
        string.setRealSize((int)len - i);
        return i;
    }

    protected void flush() {
        this.tokp = this.lex_p;
    }

    public int getBraceNest() {
        return this.braceNest;
    }

    public StackState getCmdArgumentState() {
        return this.cmdArgumentState;
    }

    public StackState getConditionState() {
        return this.conditionState;
    }

    public String getCurrentArg() {
        return this.current_arg;
    }

    public String getCurrentLine() {
        return this.lex_lastline.toString();
    }

    public Encoding getEncoding() {
        return this.current_enc;
    }

    public String getFile() {
        return this.src.getFilename();
    }

    public int getHeredocIndent() {
        return this.heredoc_indent;
    }

    public int getLeftParenBegin() {
        return this.leftParenBegin;
    }

    public ISourcePosition getPosition() {
        if (this.tokline != null && this.ruby_sourceline == this.tokline.getLine()) {
            return this.tokline;
        }
        return new SimpleSourcePosition(this.getFile(), this.ruby_sourceline);
    }

    public int getLineOffset() {
        return this.line_offset;
    }

    public int getState() {
        return this.lex_state;
    }

    public int getTokenCR() {
        return this.tokenCR;
    }

    public int incrementParenNest() {
        ++this.parenNest;
        return this.parenNest;
    }

    public boolean isEndSeen() {
        return this.__end__seen;
    }

    public boolean isASCII() {
        return Encoding.isMbcAscii((byte)((byte)this.lexb.get(this.lex_p - 1)));
    }

    public boolean isASCII(int c) {
        return Encoding.isMbcAscii((byte)((byte)c));
    }

    public boolean isGlobalCharPunct(int c) {
        switch (c) {
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 95: 
            case 96: 
            case 126: {
                return true;
            }
        }
        return this.isIdentifierChar(c);
    }

    public boolean isIdentifierChar(int c) {
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95 || !this.isASCII(c));
    }

    public void lex_goto_eol() {
        this.lex_p = this.lex_pend;
    }

    public int lineno() {
        return this.ruby_sourceline + this.src.getLineOffset();
    }

    protected void magicCommentEncoding(ByteList encoding) {
        if (!this.comment_at_top()) {
            return;
        }
        this.setEncoding(encoding);
    }

    public void newtok(boolean unreadOnce) {
        this.tokline = this.getPosition();
        this.tokenCR = 16;
        this.tokp = this.lex_p - (unreadOnce ? 1 : 0);
    }

    protected int numberLiteralSuffix(int mask) throws IOException {
        int c = this.nextc();
        if (c == 105) {
            return (mask & 2) != 0 ? mask & 2 : 0;
        }
        if (c == 114) {
            int result = 0;
            if ((mask & 1) != 0) {
                result |= mask & 1;
            }
            if (this.peek(105) && (mask & 2) != 0) {
                c = this.nextc();
                result |= mask & 2;
            }
            return result;
        }
        if (c == 46) {
            int c2 = this.nextc();
            if (Character.isDigit(c2)) {
                this.compile_error("unexpected fraction part after numeric literal");
                while (this.isIdentifierChar(c2 = this.nextc())) {
                }
            } else {
                this.pushback(c2);
            }
        }
        this.pushback(c);
        return 0;
    }

    public void parser_prepare() {
        int c = this.nextc();
        switch (c) {
            case 35: {
                if (!this.peek(33)) break;
                this.has_shebang = true;
                break;
            }
            case 239: {
                if (this.lex_pend - this.lex_p < 2 || this.p(this.lex_p) != 187 || this.p(this.lex_p + 1) != 191) break;
                this.setEncoding(UTF8_ENCODING);
                this.lex_p += 2;
                this.lex_pbeg = this.lex_p;
                return;
            }
            case -1: {
                return;
            }
        }
        this.pushback(c);
        this.current_enc = this.lex_lastline.getEncoding();
    }

    public int p(int offset) {
        return this.lexb.get(offset) & 0xFF;
    }

    public boolean peek(int c) {
        return this.peek(c, 0);
    }

    protected boolean peek(int c, int n) {
        return this.lex_p + n < this.lex_pend && this.p(this.lex_p + n) == c;
    }

    public int precise_mbclen() {
        byte[] data = this.lexb.getUnsafeBytes();
        int begin = this.lexb.begin();
        return this.current_enc.length(data, begin + this.lex_p - 1, begin + this.lex_pend);
    }

    public void printState() {
        if (this.lex_state == 0) {
            System.out.println("NULL");
        } else {
            System.out.println(this.lex_state);
        }
    }

    public void pushback(int c) {
        if (c == -1) {
            return;
        }
        --this.lex_p;
        if (this.lex_p > this.lex_pbeg && this.p(this.lex_p) == 10 && this.p(this.lex_p - 1) == 13) {
            --this.lex_p;
        }
    }

    public void reset() {
        this.braceNest = 0;
        this.commandStart = true;
        this.heredoc_indent = 0;
        this.heredoc_line_indent = 0;
        this.last_cr_line = -1;
        this.parenNest = 0;
        this.ruby_sourceline = 0;
        this.token = 0;
        this.tokenSeen = false;
        this.tokp = 0;
        this.yaccValue = null;
        this.setState(0);
        this.resetStacks();
    }

    public void resetStacks() {
        this.conditionState.reset();
        this.cmdArgumentState.reset();
    }

    protected char scanOct(int count) throws IOException {
        char value = '\u0000';
        for (int i = 0; i < count; ++i) {
            int c = this.nextc();
            if (!LexingCommon.isOctChar(c)) {
                this.pushback(c);
                break;
            }
            value = (char)(value << 3);
            value = (char)(value | Integer.parseInt(String.valueOf((char)c), 8));
        }
        return value;
    }

    public void setCurrentArg(String current_arg) {
        this.current_arg = current_arg;
    }

    public void setCurrentEncoding(Encoding encoding) {
        this.current_enc = encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.setCurrentEncoding(encoding);
        this.src.setEncoding(encoding);
        this.lexb.setEncoding(encoding);
    }

    protected void set_file_encoding(int str, int send) {
        boolean sep = false;
        block9: while (true) {
            if (send - str <= 6) {
                return;
            }
            switch (this.p(str + 6)) {
                case 67: 
                case 99: {
                    str += 6;
                    continue block9;
                }
                case 79: 
                case 111: {
                    str += 5;
                    continue block9;
                }
                case 68: 
                case 100: {
                    str += 4;
                    continue block9;
                }
                case 73: 
                case 105: {
                    str += 3;
                    continue block9;
                }
                case 78: 
                case 110: {
                    str += 2;
                    continue block9;
                }
                case 71: 
                case 103: {
                    ++str;
                    continue block9;
                }
                case 58: 
                case 61: {
                    sep = true;
                    str += 6;
                    break;
                }
                default: {
                    if (!Character.isSpaceChar(this.p(str += 6))) continue block9;
                }
            }
            if (this.lexb.makeShared(str - 6, 6).caseInsensitiveCmp(CODING) == 0) break;
        }
        while (true) {
            if (++str >= send) {
                return;
            }
            if (Character.isSpaceChar(this.p(str))) continue;
            if (sep) break;
            if (this.p(str) != 61 && this.p(str) != 58) {
                return;
            }
            sep = true;
            ++str;
        }
        int beg = str;
        while ((this.p(str) == 45 || this.p(str) == 95 || Character.isLetterOrDigit(this.p(str))) && ++str < send) {
        }
        this.setEncoding(this.lexb.makeShared(beg, str - beg));
    }

    public void setHeredocLineIndent(int heredoc_line_indent) {
        this.heredoc_line_indent = heredoc_line_indent;
    }

    public void setHeredocIndent(int heredoc_indent) {
        this.heredoc_indent = heredoc_indent;
    }

    public void setBraceNest(int nest) {
        this.braceNest = nest;
    }

    public void setLeftParenBegin(int value) {
        this.leftParenBegin = value;
    }

    public void setSource(LexerSource source) {
        this.src = source;
    }

    public void setState(int state) {
        this.lex_state = state;
    }

    public void setValue(Object yaccValue) {
        this.yaccValue = yaccValue;
    }

    protected boolean strncmp(ByteList one, ByteList two, int length) {
        if (one.length() < length || two.length() < length) {
            return false;
        }
        return one.makeShared(0, length).equal(two.makeShared(0, length));
    }

    public void tokAdd(int first_byte, ByteList buffer) {
        buffer.append((byte)first_byte);
    }

    public void tokCopy(int length, ByteList buffer) {
        buffer.append(this.lexb, this.lex_p - length, length);
    }

    public boolean tokadd_ident(int c) {
        do {
            if (this.tokadd_mbchar(c)) continue;
            return false;
        } while (this.isIdentifierChar(c = this.nextc()));
        this.pushback(c);
        return true;
    }

    public boolean tokadd_mbchar(int first_byte) {
        int length = this.precise_mbclen();
        if (length <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
        } else if (length > 1) {
            this.tokenCR = 32;
        }
        this.lex_p += length - 1;
        return true;
    }

    public boolean tokadd_mbchar(int first_byte, ByteList buffer) {
        int length = this.precise_mbclen();
        if (length <= 0) {
            this.compile_error("invalid multibyte char (" + this.getEncoding() + ")");
        }
        this.tokAdd(first_byte, buffer);
        this.lex_p += length - 1;
        if (length > 1) {
            this.tokCopy(length - 1, buffer);
        }
        return true;
    }

    public void tokaddmbc(int codepoint, ByteList buffer) {
        Encoding encoding = buffer.getEncoding();
        int length = encoding.codeToMbcLength(codepoint);
        buffer.ensure(buffer.getRealSize() + length);
        encoding.codeToMbc(codepoint, buffer.getUnsafeBytes(), buffer.begin() + buffer.getRealSize());
        buffer.setRealSize(buffer.getRealSize() + length);
    }

    public int token() {
        return this.token;
    }

    public boolean update_heredoc_indent(int c) {
        if (this.heredoc_line_indent == -1) {
            if (c == 10) {
                this.heredoc_line_indent = 0;
            }
        } else {
            if (c == 32) {
                ++this.heredoc_line_indent;
                return true;
            }
            if (c == 9) {
                int w = this.heredoc_line_indent / 8 + 1;
                this.heredoc_line_indent = w * 8;
                return true;
            }
            if (c != 10) {
                if (this.heredoc_indent > this.heredoc_line_indent) {
                    this.heredoc_indent = this.heredoc_line_indent;
                }
                this.heredoc_line_indent = -1;
            }
        }
        return false;
    }

    public void validateFormalIdentifier(String identifier) {
        char first = identifier.charAt(0);
        if (Character.isUpperCase(first)) {
            this.compile_error("formal argument cannot be a constant");
        }
        switch (first) {
            case '@': {
                if (identifier.charAt(1) == '@') {
                    this.compile_error("formal argument cannot be a class variable");
                    break;
                }
                this.compile_error("formal argument cannot be an instance variable");
                break;
            }
            case '$': {
                this.compile_error("formal argument cannot be a global variable");
                break;
            }
            default: {
                char last = identifier.charAt(identifier.length() - 1);
                if (last != '=' && last != '?' && last != '!') break;
                this.compile_error("formal argument must be local variable");
            }
        }
    }

    public Object value() {
        return this.yaccValue;
    }

    protected void warn_balanced(int c, boolean spaceSeen, String op, String syn) {
        if (!LexingCommon.isLexState(this.last_state, 908) && spaceSeen && !Character.isWhitespace(c)) {
            this.ambiguousOperator(op, syn);
        }
    }

    public boolean was_bol() {
        return this.lex_p == this.lex_pbeg + 1;
    }

    public boolean whole_match_p(ByteList eos, boolean indent) {
        int n;
        int len = eos.length();
        int p = this.lex_pbeg;
        if (indent) {
            for (int i = 0; i < this.lex_pend; ++i) {
                if (Character.isWhitespace(this.p(i + p))) continue;
                p += i;
                break;
            }
        }
        if ((n = this.lex_pend - (p + len)) < 0) {
            return false;
        }
        if (n > 0 && this.p(p + len) != 10) {
            if (this.p(p + len) != 13) {
                return false;
            }
            if (n == 1 || this.p(p + len + 1) != 10) {
                return false;
            }
        }
        return this.strncmp(eos, this.lexb.makeShared(p, len), len);
    }

    protected abstract void ambiguousOperator(String var1, String var2);

    public abstract void compile_error(String var1);

    public abstract int nextc();

    protected abstract void setCompileOptionFlag(String var1, ByteList var2);

    protected abstract void setEncoding(ByteList var1);

    protected abstract void setTokenInfo(String var1, ByteList var2);

    public abstract int tokenize_ident(int var1);

    public static boolean isHexChar(int c) {
        return Character.isDigit(c) || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static boolean isLexState(int state, int mask) {
        return (mask & state) != 0;
    }

    protected boolean isLexStateAll(int state, int mask) {
        return (mask & state) == mask;
    }

    protected boolean isARG() {
        return LexingCommon.isLexState(this.lex_state, 48);
    }

    protected boolean isBEG() {
        return LexingCommon.isLexState(this.lex_state, 577) || this.isLexStateAll(this.lex_state, 2064);
    }

    protected boolean isEND() {
        return LexingCommon.isLexState(this.lex_state, 14);
    }

    protected boolean isLabelPossible(boolean commandState) {
        return LexingCommon.isLexState(this.lex_state, 1032) && !commandState || this.isARG();
    }

    protected boolean isLabelSuffix() {
        return this.peek(58) && !this.peek(58, 1);
    }

    protected boolean isAfterOperator() {
        return LexingCommon.isLexState(this.lex_state, 384);
    }

    protected boolean isNext_identchar() throws IOException {
        int c = this.nextc();
        this.pushback(c);
        return c != -1 && (Character.isLetterOrDigit(c) || c == 95);
    }

    public static boolean isOctChar(int c) {
        return 48 <= c && c <= 55;
    }

    protected boolean isSpaceArg(int c, boolean spaceSeen) {
        return this.isARG() && spaceSeen && !Character.isWhitespace(c);
    }

    public static int magicCommentMarker(ByteList str, int begin) {
        int i = begin;
        int len = str.length();
        block4: while (i < len) {
            switch (str.charAt(i)) {
                case '-': {
                    if (i >= 2 && str.charAt(i - 1) == '*' && str.charAt(i - 2) == '-') {
                        return i + 1;
                    }
                    i += 2;
                    continue block4;
                }
                case '*': {
                    if (i + 1 >= len) {
                        return -1;
                    }
                    if (str.charAt(i + 1) != '-') {
                        i += 4;
                        continue block4;
                    }
                    if (str.charAt(i - 1) != '-') {
                        i += 2;
                        continue block4;
                    }
                    return i + 2;
                }
            }
            i += 3;
        }
        return -1;
    }

    public boolean parseMagicComment(ByteList magicLine) throws IOException {
        int result;
        int length = magicLine.length();
        if (length <= 7) {
            return false;
        }
        int beg = LexingCommon.magicCommentMarker(magicLine, 0);
        if (beg >= 0) {
            int end = LexingCommon.magicCommentMarker(magicLine, beg);
            if (end < 0) {
                return false;
            }
            length = end - beg - 3;
        } else {
            beg = 0;
        }
        int begin = magicLine.getBegin() + beg;
        Matcher matcher = magicRegexp.matcher(magicLine.unsafeBytes(), begin, begin + length);
        try {
            result = matcher.searchInterruptible(begin, begin + length, 0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (result < 0) {
            return false;
        }
        int[] begs = matcher.getRegion().beg;
        int[] ends = matcher.getRegion().end;
        String name = magicLine.subSequence(beg + begs[1], beg + ends[1]).toString().replace('-', '_');
        ByteList value = magicLine.makeShared(beg + begs[2], ends[2] - begs[2]);
        if ("coding".equals(name) || "encoding".equals(name)) {
            this.magicCommentEncoding(value);
        } else if ("frozen_string_literal".equals(name)) {
            this.setCompileOptionFlag(name, value);
        } else if ("warn_indent".equals(name)) {
            this.setTokenInfo(name, value);
        } else {
            return false;
        }
        return true;
    }
}

