/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class EnsureNode
extends Node {
    private final Node bodyNode;
    private final Node ensureNode;

    public EnsureNode(ISourcePosition position, Node bodyNode, Node ensureNode) {
        super(position, bodyNode.containsVariableAssignment() || ensureNode != null && ensureNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ENSURENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }
}

