/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.types.INameNode;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class BlockArgNode
extends Node
implements INameNode {
    private final int count;
    private String name;

    public BlockArgNode(ISourcePosition position, int count, String name) {
        super(position, false);
        this.count = count;
        this.name = name;
    }

    public BlockArgNode(ArgumentNode argNode) {
        this(argNode.getPosition(), argNode.getIndex(), argNode.getName());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.BLOCKARGNODE;
    }

    public String getLexicalName() {
        return "&" + this.getName();
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitBlockArgNode(this);
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }
}

