/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.visitor.NodeVisitor;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class ArgsCatNode
extends Node {
    private final Node firstNode;
    private final Node secondNode;

    public ArgsCatNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (firstNode != null) : "ArgsCatNode.first == null";
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor2) {
        return visitor2.visitArgsCatNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }
}

