/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.util.system.SystemInfoResult;
import com.sourceclear.util.system.SystemItem;

public class SystemInfoResults {
    private final ImmutableMap<SystemItem, SystemInfoResult> values;
    private final ImmutableSet<SystemItem> notFound;

    public SystemInfoResults(ImmutableMap<SystemItem, SystemInfoResult> values, ImmutableSet<SystemItem> notFound) {
        this.values = values;
        this.notFound = notFound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(Strings.repeat((String)"*", (int)30)).append(" System Info ").append(Strings.repeat((String)"*", (int)30)).append("\n*\n");
        for (SystemInfoResult tr : this.values.values()) {
            sb.append("* ").append(Strings.padEnd((String)tr.getItem().toString(), (int)12, (char)' ')).append(Strings.padEnd((String)String.format("version=%s", tr.getVersion()), (int)25, (char)' ')).append(String.format("%s=%s\n", tr.getValueTitle(), tr.getValue()));
        }
        sb.append("*\n");
        for (SystemItem item : this.notFound) {
            sb.append(String.format("* Not Found: %s\n", new Object[]{item}));
        }
        sb.append("*\n").append(Strings.repeat((String)"*", (int)74));
        return sb.toString();
    }

    public SystemInfoResult getItem(SystemItem item) {
        return (SystemInfoResult)this.values.get((Object)item);
    }

    public ImmutableMap<SystemItem, SystemInfoResult> getAllItems() {
        return this.values;
    }
}

