/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.io;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.util.system.OS;
import com.veracode.security.logging.SecureLogger;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;

class ExecutableResolver {
    private final Function<String, String> getEnv;
    private final boolean isOsWindows;
    private final Supplier<List<String>> path;
    private static final String PATHEXT_ENV_VAR = "PATHEXT";
    private static final SecureLogger LOGGER = SecureLogger.getLogger(ExecutableResolver.class);

    ExecutableResolver() {
        this.getEnv = System::getenv;
        this.isOsWindows = SystemUtils.IS_OS_WINDOWS;
        this.path = OS::path;
    }

    ExecutableResolver(Supplier<List<String>> path) {
        this.getEnv = System::getenv;
        this.isOsWindows = SystemUtils.IS_OS_WINDOWS;
        this.path = path;
    }

    ExecutableResolver(Function<String, String> getEnv, Supplier<List<String>> path, boolean isOsWindows) {
        this.getEnv = getEnv;
        this.isOsWindows = isOsWindows;
        this.path = path;
    }

    @Nullable
    String resolve(String name) {
        List<String> filenames = this.constructFilenamesForName(name);
        for (String path : this.path.get()) {
            path = this.removeLeadingSpacesIfReasonable(path);
            try {
                for (String filename : filenames) {
                    Path candidate = Paths.get(path, filename);
                    if (!Files.exists(candidate, new LinkOption[0]) || Files.isDirectory(candidate, new LinkOption[0]) || !Files.isExecutable(candidate)) continue;
                    return candidate.toAbsolutePath().toString();
                }
            }
            catch (InvalidPathException e) {
                LOGGER.debug("Ignoring invalid element: {}: {}", (Object)path, (Object)e.getMessage());
            }
        }
        return null;
    }

    @VisibleForTesting
    String removeLeadingSpacesIfReasonable(String pathElement) {
        if (!pathElement.matches("\\s+.*")) {
            return pathElement;
        }
        String pathWithoutLeadingSpaces = pathElement.replaceFirst("\\s+", "");
        if (this.isOsWindows && pathWithoutLeadingSpaces.matches("[A-Za-z]:.*")) {
            return pathWithoutLeadingSpaces;
        }
        if (pathWithoutLeadingSpaces.startsWith("/")) {
            return pathWithoutLeadingSpaces;
        }
        return pathElement;
    }

    Map<String, String> resolve(Collection<String> names) {
        return names.stream().map(name -> {
            String resolvedPath = this.resolve((String)name);
            return resolvedPath == null ? null : new AbstractMap.SimpleEntry<String, String>((String)name, resolvedPath);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private List<String> constructFilenamesForName(String name) {
        if (this.isOsWindows) {
            ArrayList<String> result = new ArrayList<String>();
            for (String extension : this.pathExtensions()) {
                result.add(name + extension);
            }
            result.add(name);
            return result;
        }
        return Collections.singletonList(name);
    }

    private List<String> pathExtensions() {
        String pathext = this.getEnvOrDefault(PATHEXT_ENV_VAR, ".COM;.EXE;.BAT;.CMD;.VBS;.VBE;.JS;.JSE;.WSF;.WSH;.MSC;.CPL");
        ArrayList<String> result = new ArrayList<String>();
        result.add(".ps1");
        List lowerCasedPathExt = Stream.of(pathext.split(";")).map(String::toLowerCase).collect(Collectors.toList());
        result.addAll(lowerCasedPathExt);
        return result;
    }

    private String getEnvOrDefault(String envVar, String defaultValue) {
        String result = this.getEnv.apply(envVar);
        return result != null ? result : defaultValue;
    }
}

