/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.sourceclear.api.data.LicenseData;
import com.sourceclear.api.data.evidence.BuildType;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.util.config.ConfigException;
import com.sourceclear.util.config.FailureLevel;
import com.sourceclear.util.config.Verbosity;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ScanConfig {
    private final File pathToTop;
    private final String projectName;
    private final boolean upload;
    private final Verbosity reportVerbosity;
    private final FailureLevel failureThreshold;
    private final long scanStart;
    private final String apiToken;
    private final URI apiURL;
    private final String scanID;
    private LanguageType language;
    private final LicenseData licenseData;
    private BuildType clientType;
    private String clientVersion;
    private String workspaceSlug;
    private Long linkedRepoId;

    private ScanConfig(Builder builder) throws ConfigException {
        this.pathToTop = builder.pathToTop;
        this.projectName = builder.projectName;
        this.upload = builder.hasUpload() ? builder.upload : true;
        this.reportVerbosity = builder.hasVerbosity() ? builder.reportVerbosity : Verbosity.NORMAL;
        this.failureThreshold = builder.failureThreshold;
        this.scanStart = builder.hasScanStart() ? builder.scanStart : System.currentTimeMillis();
        if (builder.hasApiToken()) {
            this.apiToken = builder.apiToken;
        } else {
            if (builder.hasRequireApiToken()) {
                throw new ConfigException("The apiToken parameter is required. Please specify it in an environment variable or in a SRC:CLR configuration file.");
            }
            this.apiToken = null;
        }
        URI uRI = this.apiURL = builder.hasApiURL() ? builder.apiURL : null;
        if (!builder.hasScanID()) {
            throw new ConfigException("Expected to find a scanID in the ScanConfig.");
        }
        this.scanID = builder.scanID;
        this.language = builder.language;
        this.licenseData = builder.licenseData;
        this.clientType = builder.clientType;
        this.clientVersion = builder.clientVersion;
        this.workspaceSlug = builder.workspaceSlug;
        this.linkedRepoId = builder.linkedRepoId;
    }

    private static <T> boolean has(T item) {
        if (item == null) {
            return false;
        }
        return !(item instanceof CharSequence) || !StringUtils.isBlank((CharSequence)((CharSequence)item));
    }

    private static <T> T coalesce(T currItem, T newItem) {
        return ScanConfig.has(currItem) ? currItem : newItem;
    }

    public File getPathToTop() {
        return this.pathToTop;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean getUpload() {
        return this.upload;
    }

    public Verbosity getReportVerbosity() {
        return this.reportVerbosity;
    }

    public Optional<FailureLevel> getFailureThreshold() {
        return Optional.ofNullable(this.failureThreshold);
    }

    public long getScanStart() {
        return this.scanStart;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public URI getApiURL() {
        return this.apiURL;
    }

    public String getScanID() {
        return this.scanID;
    }

    public LanguageType getLanguage() {
        return this.language;
    }

    public LicenseData getLicenseData() {
        return this.licenseData;
    }

    public BuildType getClientType() {
        return this.clientType;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public Optional<String> getWorkspaceSlug() {
        return Optional.ofNullable(this.workspaceSlug);
    }

    public Long getLinkedRepoId() {
        return this.linkedRepoId;
    }

    public static class Builder {
        private File pathToTop;
        private String projectName;
        private Boolean upload;
        private Verbosity reportVerbosity;
        private FailureLevel failureThreshold;
        private Long scanStart;
        private String apiToken;
        private URI apiURL;
        private String scanID;
        LanguageType language;
        private LicenseData licenseData;
        private BuildType clientType;
        private String clientVersion;
        private String workspaceSlug;
        private Long linkedRepoId;
        private boolean requireApiToken = true;

        public boolean hasRequireApiToken() {
            return this.requireApiToken;
        }

        public Builder requireApiToken(boolean requireApiToken) {
            this.requireApiToken = requireApiToken;
            return this;
        }

        public boolean hasPathToTop() {
            return ScanConfig.has(this.pathToTop);
        }

        public Builder withPathToTop(File pathToTop) {
            this.pathToTop = (File)ScanConfig.coalesce(this.pathToTop, pathToTop);
            return this;
        }

        public Builder withProjectName(String projectName) {
            this.projectName = (String)ScanConfig.coalesce(this.projectName, projectName);
            return this;
        }

        public boolean hasUpload() {
            return ScanConfig.has(this.upload);
        }

        public Builder withUpload(Boolean upload) {
            this.upload = (Boolean)ScanConfig.coalesce(this.upload, upload);
            return this;
        }

        public boolean hasVerbosity() {
            return ScanConfig.has((Object)this.reportVerbosity);
        }

        public Builder withVerbosity(Verbosity reportVerbosity) {
            this.reportVerbosity = (Verbosity)((Object)ScanConfig.coalesce((Object)this.reportVerbosity, (Object)reportVerbosity));
            return this;
        }

        public boolean hasFailureThreshold() {
            return ScanConfig.has((Object)this.failureThreshold);
        }

        public Builder withFailureThreshold(FailureLevel failureLevel) {
            this.failureThreshold = (FailureLevel)((Object)ScanConfig.coalesce((Object)this.failureThreshold, (Object)failureLevel));
            return this;
        }

        public boolean hasScanStart() {
            return ScanConfig.has(this.scanStart);
        }

        public Builder withScanStart(Long scanStart) {
            this.scanStart = (Long)ScanConfig.coalesce(this.scanStart, scanStart);
            return this;
        }

        public boolean hasApiToken() {
            return ScanConfig.has(this.apiToken);
        }

        public Builder withApiToken(String apiToken) {
            this.apiToken = (String)ScanConfig.coalesce(this.apiToken, apiToken);
            return this;
        }

        public boolean hasApiURL() {
            return ScanConfig.has(this.apiURL);
        }

        public Builder withApiURL(URI apiURL) {
            this.apiURL = (URI)ScanConfig.coalesce(this.apiURL, apiURL);
            return this;
        }

        public Builder withApiURLString(String apiURLString) throws URISyntaxException {
            if (!this.hasApiURL() && StringUtils.isNotBlank((CharSequence)apiURLString)) {
                this.apiURL = new URI(apiURLString);
            }
            return this;
        }

        public boolean hasScanID() {
            return ScanConfig.has(this.scanID);
        }

        public Builder withScanID(String scanID) {
            this.scanID = (String)ScanConfig.coalesce(this.scanID, scanID);
            return this;
        }

        public boolean hasLanguage() {
            return ScanConfig.has(this.language);
        }

        public Builder withLanguage(LanguageType language) {
            this.language = (LanguageType)ScanConfig.coalesce(this.language, language);
            return this;
        }

        public boolean hasLicenseData() {
            return ScanConfig.has(this.licenseData);
        }

        public Builder withLicenseData(LicenseData licenseData) {
            this.licenseData = licenseData;
            return this;
        }

        public boolean hasClientType() {
            return ScanConfig.has(this.clientType);
        }

        public Builder withClientType(BuildType clientType) {
            this.clientType = (BuildType)ScanConfig.coalesce(this.clientType, clientType);
            return this;
        }

        public boolean hasClientVersion() {
            return ScanConfig.has(this.clientVersion);
        }

        public Builder withClientVersion(String clientVersion) {
            this.clientVersion = (String)ScanConfig.coalesce(this.clientVersion, clientVersion);
            return this;
        }

        public boolean hasWorkspaceSlug() {
            return ScanConfig.has(this.workspaceSlug);
        }

        public Builder withWorkspaceSlug(String workspaceSlug) {
            this.workspaceSlug = (String)ScanConfig.coalesce(this.workspaceSlug, workspaceSlug);
            return this;
        }

        public Builder withLinkedRepoId(Long linkedRepoId) {
            this.linkedRepoId = linkedRepoId;
            return this;
        }

        public ScanConfig build() throws ConfigException {
            return new ScanConfig(this);
        }
    }
}

