/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.LicenseData;
import com.sourceclear.api.data.LicenseStatus;
import com.sourceclear.util.config.LicenseDataException;
import org.apache.commons.lang3.StringUtils;

public class LicenseDataCheck {
    static final String PAYMENT_REQUIRED_MSG = "Scans cannot be performed because payment has not been received. Please ask your administrator to update the payment method on file.";
    static final String TRIAL_EXPIRED_MSG = "Scans cannot be performed because the trial expired. Please login and subscribe to a plan.";
    static final String NO_LICENSE_MSG = "Unable to obtain a license. Please contact your administrator.";
    static final String LIMITS_EXCEEDED_MSG = "Your service usage exceeds allowed plan limits, so scans cannot be performed. Please login and update your plan level.";
    private static final ImmutableMap<LicenseStatus, String> INVALID_LICENSE_STATUSES = new ImmutableMap.Builder().put((Object)LicenseStatus.PAYMENT_REQUIRED, (Object)"Scans cannot be performed because payment has not been received. Please ask your administrator to update the payment method on file.").put((Object)LicenseStatus.TRIAL_EXPIRED, (Object)"Scans cannot be performed because the trial expired. Please login and subscribe to a plan.").put((Object)LicenseStatus.NONE, (Object)"Unable to obtain a license. Please contact your administrator.").put((Object)LicenseStatus.LIMITS_EXCEEDED, (Object)"Your service usage exceeds allowed plan limits, so scans cannot be performed. Please login and update your plan level.").build();

    public static void checkLicenseIsPaidOrThrow(LicenseData licenseData) throws LicenseDataException {
        LicenseStatus licenseDataStatus = licenseData.getStatus();
        String licenseStatusMessage = licenseData.getStatusMessage();
        if (INVALID_LICENSE_STATUSES.containsKey((Object)licenseDataStatus)) {
            String defaultErrMsg = (String)INVALID_LICENSE_STATUSES.get((Object)licenseDataStatus);
            throw new LicenseDataException(StringUtils.isNotBlank((CharSequence)licenseStatusMessage) ? licenseStatusMessage : defaultErrMsg);
        }
    }
}

