/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.printer;

import com.sourceclear.sgl.SGL;
import com.sourceclear.sgl.Utility;
import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import com.sourceclear.sgl.lang.printer.Edge;
import com.sourceclear.sgl.lang.printer.Node;
import com.sourceclear.sgl.lang.printer.QueryNormalizer;
import com.sourceclear.sgl.lang.step.Step;
import java.util.Set;
import java.util.stream.Collectors;

public class QueryEquality
extends ASTVisitor<Node, Node, Object>
implements PredicateVisitor<Object> {
    public static boolean checkEquality(String q1, String q2) {
        return QueryEquality.checkEquality(SGL.parse(q1), SGL.parse(q2));
    }

    public static boolean checkEquality(Expr e1, Expr e2) {
        return QueryNormalizer.normalize(e1).accept(new QueryEquality()).equals(QueryNormalizer.normalize(e2).accept(new QueryEquality()));
    }

    @Override
    public Node visitBindingSequence(BindingSequence bindingSequence) {
        throw new RuntimeException("bindings should all have been expanded by now");
    }

    @Override
    public Node visitSequence(Sequence sequence) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Node visitAddAction(AddAction action) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Node visitRemoveAction(RemoveAction action) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Node visitQuery(Query query) {
        return query.getStep().accept(this);
    }

    @Override
    public Node visitStep(Step step) {
        String name = step.getName();
        Set<Object> args = step.getArguments().stream().map(this::visit).collect(Collectors.toSet());
        if (!step.getNext().isPresent()) {
            return new Node(name, args);
        }
        Step next = step.getNext().get();
        String nextName = next.getName();
        if (nextName.equals("union")) {
            Set<Edge> edges = next.getArguments().stream().map(Argument::asStep).map(StepArgument::getStep).map(t -> t).map(s -> {
                String edgeName = s.getName();
                if (!s.getNext().isPresent()) {
                    throw new RuntimeException("an edge has to be followed by a vertex");
                }
                return new Edge(edgeName, Utility.set(s.getNext().get().accept(this)));
            }).collect(Collectors.toSet());
            return new Node(name, args, edges);
        }
        if (!next.getNext().isPresent()) {
            throw new RuntimeException("an edge has to be followed by a vertex");
        }
        return new Node(name, args, Utility.set(new Edge(nextName, Utility.set(next.getNext().get().accept(this)))));
    }

    @Override
    public Object visitPredicateArgument(PredicateArgument predicateArgument) {
        if (predicateArgument.getPredicate() instanceof Eq) {
            return predicateArgument.getValueUnsafe();
        }
        return this.isNotSupported("use of predicates other than eq");
    }

    @Override
    public Object visitTraversalArgument(StepArgument stepArgument) {
        return this.isNotSupported("use of wildcards");
    }

    @Override
    public Object visitWildcardArgument(WildcardArgument wildcardArgument) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Node visitPatterns(Patterns patterns) {
        if (!patterns.isSingleton()) {
            this.isNotSupported("use of arbitrary patterns");
        }
        return patterns.getSteps().get(0).accept(this);
    }

    @Override
    public Object visitAnd(And and) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitOr(Or or) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitNot(Neg neg) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitRelational(Relational relational) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitWithin(Within within) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitEq(Eq eq) {
        return QueryEquality.notHandledHere();
    }

    @Override
    public Object visitRegex(Regex regex) {
        return QueryEquality.notHandledHere();
    }

    private Object isNotSupported(String thing) {
        throw new RuntimeException(thing + " isn't supported in queries");
    }

    private static Object notHandledHere() {
        throw new IllegalStateException("not handled here");
    }
}

