/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.Schema;
import com.sourceclear.sgl.lang.GremlinTranslationVisitor;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.SGQLVisitor;
import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.EvaluatedArgument;
import com.sourceclear.sgl.lang.argument.EvaluatedArguments;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import com.sourceclear.sgl.lang.printer.QueryNormalizer;
import com.sourceclear.sgl.lang.step.Step;
import com.sourceclear.sgl.lang.value.Value;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class SGDLVisitor
extends GremlinTranslationVisitor
implements PredicateVisitor<Object> {
    private static final Consumer<GraphTraversal<Vertex, Vertex>> conditionalV = t -> {
        if (!(t.asAdmin().getEndStep() instanceof GraphStep)) {
            t.V(new Object[0]);
        }
    };
    private ActionType actionContext;

    public SGDLVisitor(GraphTraversalSource source) {
        super(source);
    }

    @Override
    public Void visitBindingSequence(BindingSequence bindingSequence) {
        for (Binding binding : bindingSequence.getBindings()) {
            this.env.put(binding.getVariable(), binding.getExpr());
        }
        this.visit(bindingSequence.getBody());
        return null;
    }

    @Override
    public Void visitSequence(Sequence sequence) {
        boolean allAdd = sequence.getActions().stream().allMatch(a -> a instanceof AddAction);
        boolean allRemove = sequence.getActions().stream().allMatch(a -> a instanceof RemoveAction);
        if (!allAdd && !allRemove) {
            throw new RuntimeException("add and remove actions cannot appear in the same query");
        }
        sequence.getActions().forEach(this::visit);
        return null;
    }

    @Override
    public Void visitAddAction(AddAction action) {
        this.actionContext = ActionType.ADD;
        this.visit(action.getStep());
        return null;
    }

    @Override
    public Void visitRemoveAction(RemoveAction action) {
        this.actionContext = ActionType.REMOVE;
        this.visit(action.getStep());
        return null;
    }

    private GraphTraversal<Vertex, Vertex> translateAsQuery(GraphTraversal<Vertex, Vertex> parent, Step translate) {
        SGQLVisitor visitor2 = new SGQLVisitor(parent, this.env);
        visitor2.visit(translate);
        return visitor2.getTraversal();
    }

    @Override
    public Void visitQuery(Query query) {
        throw new RuntimeException("queries are not allowed in SGDL");
    }

    @Override
    public Void visitPatterns(Patterns patterns) {
        throw new RuntimeException("patterns are not supported in SGDL");
    }

    @Override
    public Void visitStep(Step step) {
        String name = (step = this.resolveFreeVariables(step)).getName();
        if (Schema.isVertex(name)) {
            boolean edgePresent = step.getNext().isPresent();
            if (edgePresent) {
                boolean rightPresent = step.getNext().flatMap(Step::getNext).isPresent();
                if (!rightPresent) {
                    throw new RuntimeException("destination vertex required");
                }
                Step right = (Step)step.getNext().flatMap(Step::getNext).get();
                if (right.getNext().isPresent()) {
                    throw new RuntimeException("only one edge can be added at a time");
                }
                this.edge(step.only(), step.getNext().get(), right.only());
            } else {
                this.vertex(step);
            }
            return null;
        }
        throw new RuntimeException("unrecognized vertex type " + name);
    }

    private void edge(Step left, Step edge, Step right) {
        if (!Schema.isEdge(edge.getName())) {
            throw new RuntimeException("unrecognized adjacent vertex step " + edge.getName());
        }
        switch (this.actionContext) {
            case ADD: {
                String leftName = this.vertex(left);
                this.vertex(right);
                this.traversal(t -> {
                    t.addE(edge.getName());
                    t.from(leftName);
                    for (Argument argument : edge.getArguments()) {
                        argument.getKeyword().ifPresent(kw -> t.property(kw, argument.asValue().getValue(), new Object[0]));
                    }
                });
                break;
            }
            case REMOVE: {
                this.traversal(s -> s.V(new Object[0]), conditionalV);
                this.traversal(t -> this.translateAsQuery((GraphTraversal<Vertex, Vertex>)t, left));
                this.traversal(t -> {
                    t.outE(new String[]{edge.getName()});
                    for (Argument argument : edge.getArguments()) {
                        argument.getKeyword().ifPresent(kw -> t.has(kw, argument.asValue().getValue()));
                    }
                    t.filter(this.translateAsQuery((GraphTraversal<Vertex, Vertex>)new DefaultGraphTraversal().inV(), right)).sideEffect((Traversal)__.drop());
                });
            }
        }
    }

    public String vertex(Step step) {
        step = this.resolveFreeVariables(step);
        String name = step.getName();
        List<EvaluatedArgument<Object>> visitedArgs = step.getArguments().stream().map(p -> new EvaluatedArgument(p.getKeyword().orElse(null), this.visit((Argument)p))).collect(Collectors.toList());
        String fresh = this.freshName();
        switch (this.actionContext) {
            case REMOVE: {
                SGDLVisitor.vertex(name, this.traversal(s -> s.V(new Object[0]), conditionalV), visitedArgs).sideEffect((Traversal)__.drop()).constant((Object)1L);
                break;
            }
            case ADD: {
                SGDLVisitor.checkArity(name, visitedArgs);
                this.addVertex(name, visitedArgs, fresh);
            }
        }
        return fresh;
    }

    @Override
    public Object visitPredicateArgument(PredicateArgument predicateArgument) {
        return this.visit(predicateArgument.getPredicate());
    }

    @Override
    public Object visitTraversalArgument(StepArgument stepArgument) {
        throw new RuntimeException("traversals cannot be used as arguments in SGDL");
    }

    @Override
    public Object visitWildcardArgument(WildcardArgument wildcardArgument) {
        throw new RuntimeException("wildcards cannot be used as arguments in SGDL");
    }

    @Override
    public Object visitEq(Eq eq) {
        Value value = eq.getValue();
        return value.getValue();
    }

    @Override
    public Object visitRegex(Regex regex) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    @Override
    public Object visitAnd(And and) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    @Override
    public Object visitOr(Or or) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    @Override
    public Object visitNot(Neg neg) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    @Override
    public Object visitRelational(Relational relational) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    @Override
    public Object visitWithin(Within within) {
        throw new RuntimeException("predicates are not allowed in SGDL");
    }

    private void addVertex(String vertexType, List<EvaluatedArgument<Object>> visitedArgs, String fresh) {
        EvaluatedArguments args = new EvaluatedArguments(visitedArgs, Schema.getAllProperties(vertexType));
        GraphTraversal<Vertex, Vertex> traversal = this.traversal(s -> s.addV(vertexType), t -> t.addV(vertexType));
        Schema.getVertexProperties(vertexType).forEach(p -> traversal.property(p, args.get((String)p), new Object[0]));
        Schema.getPartitionKeyProperties(vertexType).forEach(p -> {
            Object value = args.get((String)p);
            if (vertexType.equals("vulnerability") && p.equals("query")) {
                value = QueryNormalizer.normalizeAndPrint((String)value);
            }
            traversal.property((Object)("_" + p), value, new Object[0]);
        });
        traversal.as(fresh, new String[0]);
    }

    private static void checkArity(String name, List<?> params) {
        int vertexArity = Schema.getVertexArity(name);
        if (params.size() != vertexArity) {
            throw new RuntimeException(String.format("Got %d arguments for vertex %s but expected %d: %s", params.size(), name, vertexArity, Schema.getAllProperties(name)));
        }
    }

    public static enum ActionType {
        ADD,
        REMOVE;

    }
}

