/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.SGLBaseVisitor;
import com.sourceclear.sgl.SGLParser;
import com.sourceclear.sgl.StepsToPatterns;
import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.Action;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Predicate;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import com.sourceclear.sgl.lang.step.Step;
import com.sourceclear.sgl.lang.value.SGLDate;
import com.sourceclear.sgl.lang.value.SGLInteger;
import com.sourceclear.sgl.lang.value.SGLString;
import com.sourceclear.sgl.lang.value.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ParseVisitor
extends SGLBaseVisitor<Expr> {
    private final List<Object> variables;

    public ParseVisitor(List<Object> vars) {
        this.variables = vars;
    }

    @Override
    public Expr visitProgram(SGLParser.ProgramContext ctx) {
        Expr result = (Expr)this.visit((ParseTree)ctx.actions());
        List<Binding> bindings = ctx.binding().stream().flatMap(b -> this.processBinding((SGLParser.BindingContext)((Object)b)).stream()).map(entry -> new Binding((String)entry.getKey(), (Step)entry.getValue())).collect(Collectors.toList());
        if (bindings.isEmpty()) {
            return result;
        }
        return new BindingSequence(bindings, result);
    }

    private List<Map.Entry<String, Step>> processBinding(SGLParser.BindingContext ctx) {
        ArrayList<Map.Entry<String, Step>> result = new ArrayList<Map.Entry<String, Step>>();
        for (SGLParser.BindingsContext context = ctx.bindings(); context != null; context = context.bindings()) {
            String name = context.IDENT().getText();
            Step rhs = this.processStep(context.step());
            result.add(new AbstractMap.SimpleEntry<String, Step>(name, rhs));
        }
        return result;
    }

    private List<Argument> processArgs(ParserRuleContext parentCtx, int i) {
        List<Argument> result = new ArrayList<Argument>();
        SGLParser.ArgsContext args = (SGLParser.ArgsContext)parentCtx.getChild(SGLParser.ArgsContext.class, i);
        SGLParser.StepsOrArgsContext targs = (SGLParser.StepsOrArgsContext)parentCtx.getChild(SGLParser.StepsOrArgsContext.class, i);
        if (args != null) {
            result = args.arg().stream().map(this::processNonStepArg).collect(Collectors.toList());
        } else if (targs != null) {
            result = targs.stepOrArg().stream().map(this::processStepOrArg).collect(Collectors.toList());
        }
        return result;
    }

    private Predicate processPredicate(SGLParser.PredicateContext ctx) {
        if (ctx.getChildCount() == 1) {
            return new Eq(this.processValue((SGLParser.ValueContext)ctx.getChild(SGLParser.ValueContext.class, 0)));
        }
        String operator = ((TerminalNode)ctx.getChild(TerminalNode.class, 0)).getText();
        if (operator.equals("(")) {
            return this.processPredicate((SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 0));
        }
        switch (operator) {
            case "within": {
                return new Within(ctx.value().stream().map(this::processValue).collect(Collectors.toSet()));
            }
            case "regex": {
                return new Regex(ParseVisitor.stripQuotes(((TerminalNode)ctx.getChild(TerminalNode.class, 1)).getText()));
            }
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                return new Relational(operator, this.processValue((SGLParser.ValueContext)ctx.getChild(SGLParser.ValueContext.class, 0)));
            }
            case "and": {
                SGLParser.PredicateContext left = (SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 0);
                SGLParser.PredicateContext right = (SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 1);
                return new And(this.processPredicate(left), this.processPredicate(right));
            }
            case "or": {
                SGLParser.PredicateContext left = (SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 0);
                SGLParser.PredicateContext right = (SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 1);
                return new Or(this.processPredicate(left), this.processPredicate(right));
            }
            case "neg": {
                SGLParser.PredicateContext left = (SGLParser.PredicateContext)ctx.getChild(SGLParser.PredicateContext.class, 0);
                return new Neg(this.processPredicate(left));
            }
        }
        throw new RuntimeException("unrecognised predicate operator " + operator);
    }

    private Value processValue(SGLParser.ValueContext ctx) {
        if (ctx.INT() != null) {
            return SGLInteger.of(Integer.parseInt(ctx.INT().getText()));
        }
        if (ctx.templateVar() != null) {
            int i = Integer.parseInt(ctx.templateVar().getChild(1).getText());
            int index = i - 1;
            if (index >= this.variables.size()) {
                throw new RuntimeException("too few template variables provided: expected at least " + i);
            }
            return Value.of(this.variables.get(i - 1));
        }
        if (ParseVisitor.getFirstTerminalNode(ctx).contentEquals("date")) {
            String text = ctx.String().getText();
            return SGLDate.of(ParseVisitor.stripQuotes(text));
        }
        if (ctx.String() != null) {
            String text = ctx.String().getText();
            return SGLString.of(ParseVisitor.stripQuotes(text));
        }
        throw new RuntimeException("unrecognised value " + ctx.getText());
    }

    private static String stripQuotes(String text) {
        return text.substring(1, text.length() - 1);
    }

    private static String getFirstTerminalNode(ParserRuleContext ctx) {
        TerminalNode child1 = (TerminalNode)ctx.getChild(TerminalNode.class, 0);
        return child1.getText().toLowerCase().trim();
    }

    private Step processStep(SGLParser.StepContext ctx) {
        SGLParser.StepContext stepContext = ctx.step();
        Step next = stepContext == null ? null : this.processStep(stepContext);
        SGLParser.VariableContext variable = ctx.variable();
        if (variable != null) {
            return new Step(variable.getText(), next);
        }
        String name = ParseVisitor.getFirstTerminalNode(ctx);
        List<Argument> args = this.processArgs(ctx, 0);
        return new Step(name, args, next);
    }

    private Argument processStepOrArg(SGLParser.StepOrArgContext ctx) {
        SGLParser.StepContext step = ctx.step();
        if (step != null) {
            return Argument.of(this.processStep(step));
        }
        return this.processNonStepArg(ctx.arg());
    }

    private Argument processNonStepArg(SGLParser.ArgContext ctx) {
        if (ctx.kwarg() != null) {
            String keyword = ctx.kwarg().IDENT().getText();
            SGLParser.PredicateContext predicate = ctx.kwarg().predicate();
            if (predicate != null) {
                return Argument.of(keyword, this.processPredicate(predicate));
            }
            if (ctx.kwarg().wildcard() != null) {
                return new WildcardArgument(keyword);
            }
            SGLParser.StepContext step = ctx.kwarg().step();
            if (step != null) {
                return new StepArgument(keyword, this.processStep(step));
            }
            throw new RuntimeException("unknown keyword argument " + (Object)((Object)ctx.kwarg()));
        }
        SGLParser.PredicateContext predicate = ctx.predicate();
        if (predicate != null) {
            return Argument.of(this.processPredicate(predicate));
        }
        if (ctx.wildcard() != null) {
            return new WildcardArgument(null);
        }
        throw new RuntimeException("unknown argument " + (Object)((Object)ctx.kwarg()));
    }

    private Expr processPatterns(SGLParser.PatternsContext ctx) {
        return this.processPatterns(ctx, new ArrayList<Step>());
    }

    private Expr processPatterns(SGLParser.PatternsContext ctx, List<Step> steps) {
        SGLParser.StepContext traversal = ctx.step();
        Step step = this.processStep(traversal);
        steps.add(step);
        if (ctx.getChildCount() > 1) {
            return this.processPatterns(ctx.patterns(), steps);
        }
        return new StepsToPatterns().preprocessPattern(steps);
    }

    @Override
    public Expr visitActions(SGLParser.ActionsContext ctx) {
        List<Action> exprs = ctx.action().stream().map(action -> {
            String actionType;
            TerminalNode type = (TerminalNode)action.getChild(TerminalNode.class, 0);
            if (type == null) {
                SGLParser.PatternsContext patternsContext = action.patterns();
                return this.processPatterns(patternsContext);
            }
            SGLParser.StepContext traversalContext = action.step();
            Step traversal = this.processStep(traversalContext);
            switch (actionType = type.getText().toLowerCase()) {
                case "add": {
                    return new AddAction(traversal);
                }
                case "remove": {
                    return new RemoveAction(traversal);
                }
            }
            throw new RuntimeException("unrecognized action type " + actionType);
        }).collect(Collectors.toList());
        if (exprs.size() == 1 && (exprs.get(0) instanceof Query || exprs.get(0) instanceof Patterns)) {
            return (Expr)exprs.get(0);
        }
        if (exprs.stream().allMatch(e -> e instanceof Action)) {
            Sequence sequence = new Sequence(exprs);
            return sequence;
        }
        throw new RuntimeException("expected either a single query or a sequence of actions");
    }
}

