/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.sgl.Result;
import com.sourceclear.sgl.Utility;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class SglDate
implements Result {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    @JsonProperty
    private final String type = "date";
    @JsonProperty
    private final Date value;

    @JsonCreator
    public SglDate(@JsonProperty(value="value") Date value) {
        this.value = value;
    }

    public String toString() {
        return SglDate.printDate(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SglDate that = (SglDate)o;
        return this.value.equals(that.value) && Objects.equals("date", that.type);
    }

    public int hashCode() {
        return Objects.hash("date", this.value);
    }

    public static Date parseDate(String value) {
        Date date;
        try {
            date = DATE_FORMAT.parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static String printDate(Date value) {
        return DATE_FORMAT.format(value);
    }

    public static String printSglDate(Date value) {
        return "date " + Utility.quoteString(SglDate.printDate(value));
    }

    public Date getValue() {
        return this.value;
    }
}

