/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.sourceclear.sgl.SGLLexer;
import com.sourceclear.sgl.SGLParser;
import com.sourceclear.sgl.ThrowingErrorListener;
import com.sourceclear.sgl.lang.BindingCollectionVisitor;
import com.sourceclear.sgl.lang.BindingInsertionVisitor;
import com.sourceclear.sgl.lang.GremlinTranslationVisitor;
import com.sourceclear.sgl.lang.ImmutableCompileConfig;
import com.sourceclear.sgl.lang.ParseVisitor;
import com.sourceclear.sgl.lang.PathAnalysisVisitor;
import com.sourceclear.sgl.lang.SGDLVisitor;
import com.sourceclear.sgl.lang.SGQLVisitor;
import com.sourceclear.sgl.lang.expr.Binding;
import com.sourceclear.sgl.lang.expr.Expr;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang.StringUtils;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;

public class SGL {
    private static final String MISMATCHED_INPUT_EOF = "mismatched input '<EOF>' expecting";
    private static final String EXTRANEOUS_INPUT_EOF = "extraneous input '<EOF>' expecting";

    public static Expr parse(String s) {
        return SGL.parse(s, Collections.emptyList());
    }

    public static Expr parse(String s, Object ... vars) {
        return SGL.parse(s, Arrays.asList(vars));
    }

    public static Expr parse(String s, List<Object> vars) {
        if (StringUtils.isBlank((String)s)) {
            throw new RuntimeException("empty SGL programs are not valid");
        }
        CodePointCharStream inputStream = CharStreams.fromString((String)s);
        SGLLexer lexer = new SGLLexer((CharStream)inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        SGLParser parser = new SGLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        SGLParser.ProgramContext tree = parser.program();
        return (Expr)new ParseVisitor(vars).visit((ParseTree)tree);
    }

    public static <S, E> GraphTraversal<S, E> compile(String s) {
        return SGL.compile(SGL.traversal(), s, Collections.emptyList());
    }

    public static <S, E> GraphTraversal<S, E> compile(String s, Object ... vars) {
        return SGL.compile(SGL.traversal(), s, vars);
    }

    public static <S, E> GraphTraversal<S, E> compile(String s, List<Object> vars) {
        return SGL.compile(SGL.traversal(), s, vars);
    }

    public static <S, E> GraphTraversal<S, E> compile(GraphTraversalSource g, String s) {
        return SGL.compile(g, s, Collections.emptyList());
    }

    public static <S, E> GraphTraversal<S, E> compile(GraphTraversalSource g, String s, Object ... vars) {
        return SGL.toGremlin(g, SGL.parse(s, vars));
    }

    public static <S, E> GraphTraversal<S, E> compile(GraphTraversalSource g, String s, List<Object> vars) {
        return SGL.toGremlin(g, SGL.parse(s, vars));
    }

    public static <S, E> GraphTraversal<S, E> compile(GraphTraversalSource g, String s, List<Object> vars, ImmutableCompileConfig.Builder config) {
        return SGL.toGremlin(g, SGL.parse(s, vars), config);
    }

    public static <S, E> GraphTraversal<S, E> toGremlin(GraphTraversalSource g, Expr expr) {
        return SGL.toGremlin(g, expr, ImmutableCompileConfig.builder());
    }

    public static <S, E> GraphTraversal<S, E> toGremlin(GraphTraversalSource g, Expr expr, ImmutableCompileConfig.Builder config) {
        GremlinTranslationVisitor visitor2;
        if (expr.isSGDL()) {
            visitor2 = new SGDLVisitor(g);
        } else {
            PathAnalysisVisitor pathAnalysis = PathAnalysisVisitor.analyze(expr);
            visitor2 = new SGQLVisitor(g, config.pathWithEdges(pathAnalysis.isWithEdges()).hasPath(pathAnalysis.isPath()).build());
        }
        visitor2.visit(expr);
        return visitor2.getTraversal();
    }

    public static <S, E> GraphTraversal<S, E> debugCompile(GraphTraversalSource g, String input) {
        Expr expr = SGL.parse(input);
        GraphTraversal<S, E> traversal = SGL.toGremlin(g, expr);
        System.out.println("\nexpr = " + expr);
        System.out.println("\nbytecode = \n");
        traversal.asAdmin().getSteps().forEach(System.out::println);
        System.out.println("\nstep = " + SGL.bytecodeToString(traversal.asAdmin().getBytecode()));
        return traversal;
    }

    static String bytecodeToString(Bytecode bytecode) {
        return GroovyTranslator.of((String)"g").translate(bytecode);
    }

    public static List<Binding> getBindings(Expr expr) {
        return (List)new BindingCollectionVisitor().visit(expr);
    }

    public static Expr prependBindings(List<Binding> bindings, Expr expr) {
        return (Expr)new BindingInsertionVisitor(bindings).visit(expr);
    }

    public static boolean isIncompleteInput(Exception e) {
        if (e instanceof ParseCancellationException) {
            ParseCancellationException e1 = (ParseCancellationException)e;
            return e1.getMessage().contains(MISMATCHED_INPUT_EOF) || e1.getMessage().contains(EXTRANEOUS_INPUT_EOF);
        }
        return false;
    }

    public static GraphTraversalSource traversal() {
        return TinkerGraph.open().traversal();
    }
}

