/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.util;

import com.sourceclear.scm.core.SCMType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLDeconstructor {
    private static final Pattern SIMPLE = Pattern.compile("^(?!http[s]?://)(?!git@)(?<target>[\\w\\.\\-_]+)/(?<repo>[\\w\\.\\-_]+)$");
    private static final Pattern GIT = Pattern.compile("git@(?<host>[\\w:\\.]+):(?<target>\\w+)/(?<repo>\\w+)\\.git");
    private static final Pattern STASH = Pattern.compile("http[s]?://(?<host>[\\w:\\.]+)/scm/(?<target>[\\w~]+)/(?<repo>\\w+)\\.git");
    private final String host;
    private final String targetName;
    private final String repoName;

    public URLDeconstructor(SCMType scmType, String url) throws URISyntaxException {
        Matcher m = STASH.matcher(url);
        if (SCMType.STASH == scmType && m.matches()) {
            this.targetName = m.group("target");
            this.repoName = m.group("repo");
            this.host = m.group("host");
            return;
        }
        m = SIMPLE.matcher(url);
        if (m.matches()) {
            this.targetName = m.group("target");
            this.repoName = m.group("repo");
            this.host = null;
        } else if (GIT.matcher(url).matches()) {
            m = GIT.matcher(url);
            m.matches();
            this.targetName = m.group("target");
            this.repoName = m.group("repo");
            this.host = m.group("host");
        } else if (url.startsWith("git@")) {
            int indexOfAt = url.indexOf("@");
            int indexOfColon = url.indexOf(":");
            this.host = url.substring(indexOfAt + 1, indexOfColon);
            String[] splitUrl = url.split("/");
            this.repoName = splitUrl[splitUrl.length - 1];
            this.targetName = url.substring(indexOfColon + 1);
        } else {
            URI uri = new URI(url);
            String path = uri.getPath();
            this.targetName = path.split("/")[1];
            String repo = path.split("/")[2];
            if (repo.endsWith(".git")) {
                repo = repo.substring(0, repo.length() - 4);
            }
            this.repoName = repo;
            String str = uri.getAuthority();
            if (uri.getPort() != -1) {
                str = str + ":" + uri.getPort() + "/";
            }
            this.host = str;
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getRepoName() {
        return this.repoName;
    }
}

