/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.InstanceType;
import com.sourceclear.rubysonar.types.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.SelfNode;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.lexer.yacc.SimpleSourcePosition;

public class ClassType
implements Type {
    @NotNull
    private final String name;
    @Nullable
    private InstanceType canon;
    @Nullable
    private Type superclass;
    @NotNull
    private State table;
    private final ISourcePosition DUMMY_LOCATION = new SimpleSourcePosition("<dummy>", -1);
    private final SelfNode SELF_NODE = new SelfNode(this.DUMMY_LOCATION);

    public ClassType(@NotNull String name, @Nullable State parent) {
        this.name = name;
        this.table = new State(parent, State.StateType.CLASS);
        this.table.setType(this);
        if (parent != null) {
            this.table.setPath(parent.extendPath(name, "::"));
        } else {
            this.table.setPath(name);
        }
        this.table.insert("self", this.SELF_NODE, this, Binding.Kind.SCOPE);
    }

    public ClassType(@NotNull String name, State parent, @Nullable ClassType superClass) {
        this(name, parent);
        if (superClass != null) {
            this.addSuper(superClass);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Type getSuperclass() {
        return this.superclass;
    }

    public void addSuper(@NotNull Type superclass) {
        this.superclass = superclass;
        this.table.setSuper(superclass.getTable());
    }

    public InstanceType getCanon() {
        if (this.canon == null) {
            this.canon = new InstanceType(this);
        }
        return this.canon;
    }

    public void setCanon(@NotNull InstanceType canon) {
        this.canon = canon;
    }

    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.name).append(">");
        return sb.toString();
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

