/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.Utils;
import com.sourceclear.rubysonar.option.Option;
import com.sourceclear.rubysonar.option.Options;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.ModuleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.Types;
import com.sourceclear.rubysonar.types.UnionType;
import com.veracode.security.logging.SecureLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;

public class State {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(State.class);
    @NotNull
    public Map<String, List<Binding>> table = new HashMap<String, List<Binding>>();
    @Nullable
    private State parent;
    @Nullable
    public State supers;
    public StateType stateType;
    public Type type;
    @NotNull
    public String path = "";
    private int lambdaCount = 0;
    private State globalTable;
    private boolean blockGiven = false;
    private String blockParameterName;
    @Nullable
    private Queue<FunType> uncalledMethods;
    @Nullable
    private Set<MethodDefNode> discoveredUncalledMethods;
    private Option<String> functionName = Options.none();
    @Nullable
    private Set<String> callStack;
    @NotNull
    private static Set<State> looked = new HashSet<State>();

    public State(@Nullable State parent, StateType type) {
        if (parent == null) {
            this.globalTable = this;
            this.uncalledMethods = new LinkedList<FunType>();
            this.discoveredUncalledMethods = new HashSet<MethodDefNode>();
            this.callStack = new HashSet<String>();
        } else {
            this.globalTable = parent.getGlobalTable();
        }
        this.parent = parent;
        this.stateType = type;
    }

    public State(@NotNull State s) {
        this.table = new HashMap<String, List<Binding>>();
        this.table.putAll(s.table);
        this.parent = s.parent;
        this.stateType = s.stateType;
        this.supers = s.supers;
        this.type = s.type;
        this.path = s.path;
        this.globalTable = s.getGlobalTable();
    }

    public void overwrite(@NotNull State s) {
        this.table = s.table;
        this.parent = s.parent;
        this.stateType = s.stateType;
        this.supers = s.supers;
        this.type = s.type;
        this.path = s.path;
    }

    @NotNull
    public State copy() {
        return new State(this);
    }

    public void merge(State other) {
        List<Binding> b2;
        List<Binding> b1;
        for (Map.Entry<String, List<Binding>> e1 : this.table.entrySet()) {
            b1 = e1.getValue();
            b2 = other.table.get(e1.getKey());
            if (b2 == null || b1 == b2) continue;
            b1.addAll(b2);
        }
        for (Map.Entry<String, List<Binding>> e2 : other.table.entrySet()) {
            b1 = this.table.get(e2.getKey());
            b2 = e2.getValue();
            if (b1 != null || b1 == b2) continue;
            this.update(e2.getKey(), b2);
        }
    }

    public static State merge(State state1, State state2) {
        State ret = state1.copy();
        ret.merge(state2);
        return ret;
    }

    public void setParent(@Nullable State parent) {
        this.parent = parent;
    }

    public void setSuper(State sup) {
        this.supers = sup;
    }

    public void setStateType(StateType type) {
        this.stateType = type;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public boolean isGlobalName(@NotNull String name) {
        return name.startsWith("$");
    }

    public void remove(String id) {
        this.table.remove(id);
    }

    public void insert(@NotNull String id, Node node, Type type, Binding.Kind kind) {
        Binding b = new Binding(node, type, kind);
        if (type instanceof ModuleType) {
            b.setQname(((ModuleType)type).getQname());
        } else if (type instanceof FunType) {
            if (id.endsWith("^class")) {
                b.setQname(this.extendPath(id, "."));
            } else {
                b.setQname(this.extendPath(id, "#"));
            }
        } else {
            b.setQname(this.extendPath(id, "::"));
        }
        this.update(id, b);
    }

    public String makeTagId(String id, String tag) {
        return id + "^" + tag;
    }

    @NotNull
    public List<Binding> update(String id, @NotNull List<Binding> bs) {
        this.table.put(id, bs);
        return bs;
    }

    @NotNull
    public List<Binding> update(String id, @NotNull Binding b) {
        ArrayList<Binding> bs = new ArrayList<Binding>();
        bs.add(b);
        this.table.put(id, bs);
        return bs;
    }

    public void insertTagged(String id, String tag, Node node, Type type, Binding.Kind kind) {
        this.insert(this.makeTagId(id, tag), node, type, kind);
    }

    @NotNull
    public List<Binding> updateTagged(String id, String tag, @NotNull List<Binding> bs) {
        return this.update(this.makeTagId(id, tag), bs);
    }

    @NotNull
    public List<Binding> updateTagged(String id, String tag, @NotNull Binding b) {
        return this.update(this.makeTagId(id, tag), b);
    }

    public void updateType(String id, @NotNull Type type) {
        List<Binding> bs = this.lookup(id);
        ArrayList<Binding> replacement = new ArrayList<Binding>();
        if (bs != null) {
            for (Binding b : bs) {
                if (b == null) continue;
                replacement.add(new Binding(b.node, type, b.kind));
            }
        } else {
            LOGGER.trace("Unable to find binding {} in state {}", (Object)id, (Object)this);
        }
        this.update(id, replacement);
    }

    public void setPath(@NotNull String path) {
        this.path = path;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Nullable
    public List<Binding> lookupLocal(String name) {
        return this.table.get(name);
    }

    @Nullable
    public List<Binding> lookupLocalTagged(String name, String tag) {
        return this.lookupLocal(this.makeTagId(name, tag));
    }

    @NotNull
    public Type lookupLocalType(String name) {
        List<Binding> bindings = this.lookupLocal(name);
        if (bindings != null) {
            return State.makeUnion(bindings);
        }
        return Types.UNKNOWN;
    }

    @Nullable
    public List<Binding> lookup(@NotNull String name) {
        List<Binding> b = this.getModuleBindingIfGlobal(name);
        if (b != null) {
            return b;
        }
        List<Binding> ent = this.lookupLocal(name);
        if (ent != null) {
            return ent;
        }
        if (this.parent != null && this.parent != this) {
            return this.parent.lookup(name);
        }
        return null;
    }

    @Nullable
    public List<Binding> lookupTagged(@NotNull String name, String tag) {
        return this.lookup(this.makeTagId(name, tag));
    }

    @Nullable
    public List<Binding> lookupScope(String name) {
        List<Binding> b = this.getModuleBindingIfGlobal(name);
        if (b != null) {
            return b;
        }
        return this.lookupLocal(name);
    }

    @Nullable
    public List<Binding> lookupAttr(String attr) {
        if (looked.contains(this)) {
            return null;
        }
        List<Binding> b = this.lookupLocal(attr);
        if (b != null) {
            return b;
        }
        if (this.supers != null && !this.supers.isEmpty()) {
            looked.add(this);
            b = this.supers.lookupAttr(attr);
            if (b != null) {
                looked.remove(this);
                return b;
            }
            looked.remove(this);
            return null;
        }
        return null;
    }

    @Nullable
    public List<Binding> lookupAttrTagged(String attr, String tag) {
        return this.lookupAttr(this.makeTagId(attr, tag));
    }

    @NotNull
    public Type lookupType(String name) {
        List<Binding> bs = this.lookup(name);
        if (bs == null) {
            return Types.UNKNOWN;
        }
        return State.makeUnion(bs);
    }

    @Nullable
    public Type lookupAttrType(String attr) {
        List<Binding> bs = this.lookupAttr(attr);
        if (bs == null) {
            return null;
        }
        return State.makeUnion(bs);
    }

    @Nullable
    Type lookupLocalTypeTagged(String name, String tag) {
        return this.lookupLocalType(this.makeTagId(name, tag));
    }

    @Nullable
    Type lookupTypeTagged(String name, String tag) {
        return this.lookupType(this.makeTagId(name, tag));
    }

    @Nullable
    public Type lookupAttrTypeTagged(String attr, String tag) {
        return this.lookupAttrType(this.makeTagId(attr, tag));
    }

    public static Type makeUnion(@NotNull List<Binding> bs) {
        Type t = Types.UNKNOWN;
        for (Binding b : bs) {
            t = UnionType.union(t, b.type);
        }
        return t;
    }

    @Nullable
    public State getStateOfType(StateType type) {
        if (this.stateType == type) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getStateOfType(type);
    }

    @NotNull
    public State getGlobalTable() {
        return this.globalTable;
    }

    @Nullable
    private List<Binding> getModuleBindingIfGlobal(@NotNull String name) {
        State module;
        if (this.isGlobalName(name) && (module = this.getGlobalTable()) != this) {
            return module.lookupLocal(name);
        }
        return null;
    }

    public void putAll(@NotNull State other) {
        for (Map.Entry<String, List<Binding>> e : other.table.entrySet()) {
            if ("self".equals(e.getKey()) || "this".equals(e.getKey())) continue;
            this.table.put(e.getKey(), e.getValue());
        }
    }

    @NotNull
    public Set<String> keySet() {
        return this.table.keySet();
    }

    @NotNull
    public Collection<Binding> values() {
        ArrayList<Binding> ret = new ArrayList<Binding>();
        for (List<Binding> bs : this.table.values()) {
            ret.addAll(bs);
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @NotNull
    public String extendPath(@NotNull String name, String sep) {
        if ("self".equals(name = Utils.mainName(name)) || "this".equals(name)) {
            return this.path;
        }
        if ("".equals(this.path)) {
            return name;
        }
        return this.path + sep + name;
    }

    @NotNull
    public String toString() {
        return "(state:" + (Object)((Object)this.getStateType()) + ":" + this.table.keySet() + ")";
    }

    @Nullable
    public State getParent() {
        return this.parent;
    }

    public int getLambdaCount() {
        return this.lambdaCount;
    }

    public void setLambdaCount(int lambdaCount) {
        this.lambdaCount = lambdaCount;
    }

    String freshLambdaName() {
        String name = "lambda%" + this.getGlobalTable().getLambdaCount();
        this.setLambdaCount(this.getGlobalTable().getLambdaCount() + 1);
        return name;
    }

    public static State newGlobalTable() {
        return new State(null, StateType.GLOBAL);
    }

    String getBlockParameterName() {
        return this.blockParameterName;
    }

    void setBlockParameterName(String blockParameterName) {
        this.blockGiven = true;
        this.blockParameterName = blockParameterName;
    }

    public boolean blockGiven() {
        return this.blockGiven;
    }

    public void addUncalledMethod(FunType method) {
        State globalTable = this.getGlobalTable();
        if (globalTable.uncalledMethods == null || globalTable.discoveredUncalledMethods == null) {
            LOGGER.debug("Uncalled method not initialized in global table >_<");
        } else if (!globalTable.discoveredUncalledMethods.contains(method.getMethodDefNode())) {
            globalTable.discoveredUncalledMethods.add(method.getMethodDefNode());
            globalTable.uncalledMethods.add(method);
        }
    }

    @Nullable
    public Queue<FunType> getUncalledMethods() {
        return this.getGlobalTable().uncalledMethods;
    }

    public void setFunctionName(String functionName) {
        this.functionName = Options.of(functionName);
    }

    public Option<String> getFunctionName() {
        return this.functionName;
    }

    public void pushCallStack(String methodQualifiedName) {
        this.getGlobalTable().callStack.add(methodQualifiedName);
    }

    public void popCallStack(String methodQualifiedName) {
        this.getGlobalTable().callStack.remove(methodQualifiedName);
    }

    public boolean inCallStack(String methodQualifiedName) {
        return this.getGlobalTable().callStack.contains(methodQualifiedName);
    }

    public static enum StateType {
        CLASS,
        INSTANCE,
        FUNCTION,
        MODULE,
        GLOBAL,
        SCOPE;

    }
}

