/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.rubysonar.types.Type;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.ast.Node;
import org.jrubyparser.lexer.yacc.ISourcePosition;

public class Binding
implements Comparable<Object> {
    @NotNull
    public Node node;
    @NotNull
    public String qname;
    public Type type;
    public Kind kind;
    public Set<Node> refs;
    private int start = -1;
    private int end = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    @Nullable
    public String file;

    public Binding(@NotNull Node node, @NotNull Type type, @NotNull Kind kind) {
        this.qname = type.getTable().path;
        this.type = type;
        this.kind = kind;
        this.node = node;
        this.refs = new LinkedHashSet<Node>(1);
        this.file = node.getPosition().getFile();
        this.initLocationInfo(node);
    }

    private void initLocationInfo(Node node) {
        ISourcePosition position = node.getPosition();
        this.start = position.getLine();
        this.end = position.getLine();
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public void setQname(@NotNull String qname) {
        this.qname = qname;
    }

    public void addRef(Node ref) {
        this.refs.add(ref);
    }

    @Override
    public int compareTo(@NotNull Object o) {
        return this.start - ((Binding)o).start;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(binding:");
        sb.append(":kind=").append((Object)this.kind);
        sb.append(":node=").append(this.node);
        sb.append(":type=").append(this.type);
        sb.append(":qname=").append(this.qname);
        sb.append(":refs=");
        if (this.refs.size() > 10) {
            sb.append("[");
            sb.append(this.refs.iterator().next());
            sb.append(", ...(");
            sb.append(this.refs.size() - 1);
            sb.append(" more)]");
        } else {
            sb.append(this.refs);
        }
        sb.append(">");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Binding)) {
            return false;
        }
        Binding b = (Binding)obj;
        return this.start == b.start && this.end == b.end && Objects.equals(this.file, b.file);
    }

    public int hashCode() {
        return ("" + this.file + this.start).hashCode();
    }

    public static enum Kind {
        MODULE,
        CLASS,
        METHOD,
        CLASS_METHOD,
        ATTRIBUTE,
        PARAMETER,
        SCOPE,
        VARIABLE,
        CONSTANT;

    }
}

