/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar;

import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.rubysonar.Binding;
import com.sourceclear.rubysonar.Builtins;
import com.sourceclear.rubysonar.HashableDefnNode;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.TypeInferencer;
import com.sourceclear.rubysonar.Utils;
import com.sourceclear.rubysonar.Visitor;
import com.sourceclear.rubysonar.option.Option;
import com.sourceclear.rubysonar.option.Options;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.FunType;
import com.sourceclear.rubysonar.types.IntType;
import com.sourceclear.rubysonar.types.ModuleType;
import com.sourceclear.rubysonar.types.TupleType;
import com.sourceclear.rubysonar.types.Type;
import com.sourceclear.rubysonar.types.Types;
import com.sourceclear.util.security.SecurityUtils;
import com.veracode.security.logging.SecureLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jrubyparser.Parser;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.EmptyArgsNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.TrueNode;
import org.jrubyparser.lexer.yacc.ISourcePosition;
import org.jrubyparser.lexer.yacc.SimpleSourcePosition;
import org.jrubyparser.lexer.yacc.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;

public class Analyzer {
    private Path cwd = null;
    private final State globalTable;
    private List<Path> path = new ArrayList<Path>();
    private Set<Path> imported = new HashSet<Path>();
    private Path projectDir;
    @NotNull
    private static Parser parser = new Parser();
    @NotNull
    private static ParserConfiguration configuration = new ParserConfiguration(0);
    private static final SecureLogger LOGGER = SecureLogger.getLogger(Analyzer.class);
    private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.rb");
    private final List<Visitor> visitors = new ArrayList<Visitor>();
    private final Map<Path, Option<Node>> astCache = new HashMap<Path, Option<Node>>();
    private static final List<Charset> supportedCharsets = Arrays.asList(StandardCharsets.UTF_8, StandardCharsets.UTF_16, StandardCharsets.ISO_8859_1, StandardCharsets.US_ASCII);
    private static final int FILE_SIZE_LIMIT = 0x500000;
    private final VulnMethodsConfig config;

    public Analyzer() throws IOException {
        this(VulnMethodsConfig.Builder.ruby().build(), State.newGlobalTable());
    }

    public Analyzer(VulnMethodsConfig config) throws IOException {
        this(config, State.newGlobalTable());
    }

    public Analyzer(@NotNull State globalTable) throws IOException {
        this(VulnMethodsConfig.Builder.ruby().build(), globalTable);
    }

    public Analyzer(@NotNull VulnMethodsConfig config, @NotNull State globalTable) throws IOException {
        this.config = config;
        this.addEnvPath();
        this.globalTable = globalTable;
        Builtins.initPredefinedGlobals(globalTable);
        Builtins.initFixnumClass(globalTable, new IntType(globalTable));
        Builtins.initArrayClass(globalTable, Types.UNKNOWN);
        Builtins.initStructClass(globalTable);
        TypeInferencer typeInferencer = new TypeInferencer(globalTable);
        this.visitors.add(typeInferencer);
    }

    public void analyze(Path path) throws IOException {
        Path upath = Utils.unifyPath(path);
        this.projectDir = Files.isDirectory(upath, new LinkOption[0]) ? upath : upath.getParent();
        for (Visitor visitor2 : this.visitors) {
            visitor2.setState(this.globalTable);
            this.load(upath, visitor2);
            visitor2.finish();
        }
    }

    public void setCWD(Path cd) throws IOException {
        if (cd != null) {
            this.cwd = Utils.unifyPath(cd);
        }
    }

    public void addPaths(@NotNull List<Path> p) throws IOException {
        for (Path s : p) {
            this.addPath(s);
        }
    }

    public void addPath(Path p) throws IOException {
        this.path.add(Utils.unifyPath(p));
    }

    public void setPath(@NotNull List<Path> path) throws IOException {
        this.path = new ArrayList<Path>(path.size());
        this.addPaths(path);
    }

    private void addEnvPath() throws IOException {
        String path = System.getenv("RUBYLIB");
        if (path != null) {
            String[] segments;
            for (String p : segments = path.split(":")) {
                Path rubyLibPath = Paths.get(p, new String[0]);
                if (!SecurityUtils.isSecureRelativePath(rubyLibPath)) continue;
                this.addPath(rubyLibPath);
            }
        }
    }

    @NotNull
    public List<Path> getLoadPath() {
        ArrayList<Path> loadPath = new ArrayList<Path>();
        loadPath.addAll(this.path);
        if (this.cwd != null) {
            loadPath.add(this.cwd);
        }
        if (this.projectDir != null && Files.isDirectory(this.projectDir, new LinkOption[0])) {
            loadPath.add(this.projectDir);
        }
        return loadPath;
    }

    public void loadMethod(@NotNull List<String> modules, @Nullable String className, @NotNull String methodName) {
        SimpleSourcePosition dummyPosition = new SimpleSourcePosition("<dummy>", 0);
        TrueNode dummy = new TrueNode(dummyPosition);
        State parent = this.globalTable;
        for (String module : modules) {
            ModuleType moduleType;
            Type lookupResult = parent.lookupType(module);
            if (lookupResult instanceof ModuleType) {
                moduleType = (ModuleType)lookupResult;
            } else {
                moduleType = new ModuleType(module, null, parent);
                parent.insert(module, new Colon3Node((ISourcePosition)dummyPosition, module), moduleType, Binding.Kind.MODULE);
            }
            parent = moduleType.getTable();
        }
        HashableDefnNode methodDefNode = new HashableDefnNode(dummyPosition, methodName, new EmptyArgsNode(), null, dummy, 0);
        FunType funType = new FunType(methodDefNode, new State(parent, State.StateType.FUNCTION));
        if (className != null) {
            ClassType classType;
            Type lookupResult = parent.lookupType(className);
            if (lookupResult instanceof ClassType) {
                classType = (ClassType)lookupResult;
            } else {
                classType = new ClassType(className, parent);
                parent.insert(className, dummy, classType, Binding.Kind.CLASS);
            }
            parent = classType.getTable();
            funType.setClassType(classType);
        }
        funType.getTable().setParent(parent);
        funType.addMapping(new TupleType((Type)Types.UNKNOWN), Types.UNKNOWN);
        parent.insert(methodName, methodDefNode, funType, Binding.Kind.METHOD);
    }

    @Nullable
    private <T> T loadFile(Path path, Visitor<T> visitor2) throws IOException {
        if (!Files.isReadable(path = Utils.unifyPath(path))) {
            return null;
        }
        if (this.imported.contains(path)) {
            return null;
        }
        Path oldcwd = this.cwd;
        this.setCWD(path.getParent());
        this.imported.add(path);
        T t = this.parseAndVisit(path, visitor2);
        this.setCWD(oldcwd);
        this.imported.remove(path);
        return t;
    }

    @Nullable
    private <T> T parseAndVisit(Path file, Visitor<T> visitor2) throws IOException {
        Option<Node> node = this.getAstForFile(file);
        if (node.isEmpty()) {
            LOGGER.debug("Failed to parse {}", (Object)file);
            return null;
        }
        return node.get().accept(visitor2);
    }

    @NotNull
    Option<Node> getAstForFile(Path path) throws IOException {
        if (Files.size(path) > 0x500000L) {
            LOGGER.warn("File is more than 5 MB. Skipping... {}", (Object)path.toString());
            return Options.none();
        }
        Option<Node> cached = this.astCache.get(path);
        if (cached != null) {
            return cached;
        }
        Option<Node> node = Options.none();
        try {
            node = this.parseTryCharsets(path);
            this.astCache.put(path, node);
        }
        catch (IOException e) {
            LOGGER.debug("Unable to parse {}", (Object)path, (Object)e);
        }
        catch (SyntaxException e) {
            LOGGER.debug("Unable to parse due to syntax error in {}", (Object)path, (Object)e);
        }
        catch (RuntimeException e) {
            LOGGER.debug("Unable to parse {} due to runtime exception", (Object)path, (Object)e);
        }
        return node;
    }

    private Option<Node> parseTryCharsets(Path path) throws IOException {
        for (Charset charset : supportedCharsets) {
            Option<Node> node = this.parseWithCharset(path, charset);
            if (!node.isDefined()) continue;
            return node;
        }
        return Options.none();
    }

    private Option<Node> parseWithCharset(Path path, Charset cs) throws IOException {
        Option<Node> option;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path, cs);
            try {
                option = Options.of(parser.parse(path.toString(), reader, configuration));
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedInputException e) {
                    return Options.none();
                }
            }
            ((Reader)reader).close();
        }
        return option;
    }

    private boolean isIgnoredDirectory(Path path) {
        return this.config.ignoredDirectories().contains(path.getFileName().toString());
    }

    public void load(Path path, final Visitor visitor2) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0]) && !this.isIgnoredDirectory(path)) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (Analyzer.this.isIgnoredDirectory(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (Analyzer.this.matcher.matches(file)) {
                        try {
                            Analyzer.this.loadFile(file, visitor2);
                        }
                        catch (IOException e) {
                            LOGGER.debug("Unable to load file {}. Skipping...", (Object)file, (Object)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (Files.isRegularFile(path, new LinkOption[0]) && this.matcher.matches(path)) {
            this.loadFile(path, visitor2);
        }
    }

    public void addVisitor(Visitor visitor2) {
        this.visitors.add(visitor2);
    }

    public void finish() {
        for (Visitor visitor2 : this.visitors) {
            visitor2.finish();
        }
    }
}

