/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.NodeType;
import java.math.BigInteger;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class PyInt
extends Node {
    public BigInteger value;

    public PyInt(Analyzer analyzer, String s, Path file, int lineNumber, int start, int end) {
        super(analyzer, NodeType.PYINT, file, lineNumber, start, end);
        int base;
        s = s.replaceAll("_", "");
        int sign = 1;
        if (s.startsWith("+")) {
            s = s.substring(1);
        } else if (s.startsWith("-")) {
            s = s.substring(1);
            sign = -1;
        }
        if (s.startsWith("0b")) {
            base = 2;
            s = s.substring(2);
        } else if (s.startsWith("0x")) {
            base = 16;
            s = s.substring(2);
        } else if (s.startsWith("x")) {
            base = 16;
            s = s.substring(1);
        } else if (s.startsWith("0o")) {
            base = 8;
            s = s.substring(2);
        } else if (s.startsWith("0") && s.length() >= 2) {
            base = 8;
            s = s.substring(1);
        } else {
            base = 10;
        }
        this.value = new BigInteger(s, base);
        if (sign == -1) {
            this.value = this.value.negate();
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "(int:" + this.value + ")";
    }
}

