/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Parser;
import com.sourceclear.pysonar.PythonSyntaxErrorException;
import com.sourceclear.pysonar.ast.Node;
import com.veracode.security.logging.SecureLogger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AstCache
implements Closeable {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(AstCache.class);
    @NotNull
    private Map<Path, Node> cache = new HashMap<Path, Node>();
    @NotNull
    private Parser parser;

    AstCache(Analyzer analyzer) throws IOException {
        this.parser = new Parser(analyzer);
    }

    @VisibleForTesting
    AstCache(Path tempDir, Analyzer analyzer) throws IOException {
        this.parser = new Parser(tempDir, analyzer);
    }

    @Override
    public void close() throws IOException {
        this.cache.clear();
        this.parser.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Node getAST(@NotNull Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            LOGGER.debug("Path {} is a directory. Unable to parse ast for directories.", (Object)path);
            return null;
        }
        Node node = this.cache.get(path);
        if (node != null) {
            return node;
        }
        node = null;
        try {
            LOGGER.debug("parsing {}", (Object)path);
            node = this.parser.parseFile(path);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to parse file {}", (Object)path, (Object)e);
        }
        catch (PythonSyntaxErrorException e) {
            LOGGER.warn(e.getMessage());
        }
        finally {
            this.cache.put(path, node);
        }
        return node;
    }
}

